/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.AnyObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.MutableObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectIdSet;

public class LazyObjectIdSetFile
implements ObjectIdSet {
    private final File src;
    private ObjectIdOwnerMap<Entry> set;

    public LazyObjectIdSetFile(File src) {
        this.src = src;
    }

    @Override
    public boolean contains(AnyObjectId objectId) {
        if (this.set == null) {
            this.set = this.load();
        }
        return this.set.contains(objectId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectIdOwnerMap<Entry> load() {
        ObjectIdOwnerMap<Entry> r = new ObjectIdOwnerMap<Entry>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fin = new FileInputStream(this.src);
                try {
                    block21: {
                        InputStreamReader rin = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
                        try {
                            try (BufferedReader br = new BufferedReader(rin);){
                                String line;
                                MutableObjectId id = new MutableObjectId();
                                while ((line = br.readLine()) != null) {
                                    id.fromString(line);
                                    if (r.contains(id)) continue;
                                    r.add(new Entry(id));
                                }
                            }
                            if (rin == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (rin == null) throw throwable;
                            ((Reader)rin).close();
                            throw throwable;
                        }
                        ((Reader)rin).close();
                    }
                    if (fin == null) return r;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fin == null) throw throwable;
                    fin.close();
                    throw throwable;
                }
                fin.close();
                return r;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return r;
    }

    static class Entry
    extends ObjectIdOwnerMap.Entry {
        Entry(AnyObjectId id) {
            super(id);
        }
    }
}

