/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.diff;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum DiffDriver {
    cpp(List.of("^[ \\t]*[A-Za-z_][A-Za-z_0-9]*:\\s*($|/[/*])"), List.of("^((::\\s*)?[A-Za-z_].*)$")),
    dts(List.of(";", "="), List.of("^[ \\t]*((/[ \\t]*\\{|&?[a-zA-Z_]).*)")),
    java(List.of("^[ \\t]*(catch|do|for|if|instanceof|new|return|switch|throw|while)"), List.of("^[ \\t]*(([a-z-]+[ \\t]+)*(class|enum|interface|record)[ \\t]+.*)$", "^[ \\t]*(([A-Za-z_<>&\\]\\[][?&<>.,A-Za-z_0-9]*[ \\t]+)+[A-Za-z_][A-Za-z_0-9]*[ \\t]*\\([^;]*)$")),
    python(List.of("^[ \\t]*((class|(async[ \\t]+)?def)[ \\t].*)$")),
    rust(List.of("^[\\t ]*((pub(\\([^\\)]+\\))?[\\t ]+)?((async|const|unsafe|extern([\\t ]+\"[^\"]+\"))[\\t ]+)?(struct|enum|union|mod|trait|fn|impl|macro_rules!)[< \\t]+[^;]*)$"));

    private final List<Pattern> negatePatterns;
    private final List<Pattern> matchPatterns;

    private DiffDriver(List<String> negate, List<String> match, int flags) {
        this.negatePatterns = negate != null ? negate.stream().map(r -> Pattern.compile(r, flags)).collect(Collectors.toList()) : null;
        this.matchPatterns = match.stream().map(r -> Pattern.compile(r, flags)).collect(Collectors.toList());
    }

    private DiffDriver(List<String> match) {
        this(null, match, 0);
    }

    private DiffDriver(List<String> negate, List<String> match) {
        this(negate, match, 0);
    }

    public List<Pattern> getNegatePatterns() {
        return this.negatePatterns;
    }

    public List<Pattern> getMatchPatterns() {
        return this.matchPatterns;
    }
}

