/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Locale;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.ConfigInvalidException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Config;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.FS;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.IO;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.RawParseUtils;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.StringUtils;

public class CommitConfig {
    public static final Config.SectionParser<CommitConfig> KEY = CommitConfig::new;
    private static final String CUT = " ------------------------ >8 ------------------------\n";
    private static final char[] COMMENT_CHARS = new char[]{'#', ';', '@', '!', '$', '%', '^', '&', '|', ':'};
    private static final Charset DEFAULT_COMMIT_MESSAGE_ENCODING = StandardCharsets.UTF_8;
    private String i18nCommitEncoding;
    private String commitTemplatePath;
    private CleanupMode cleanupMode;
    private char commentCharacter = (char)35;
    private boolean autoCommentChar = false;

    private CommitConfig(Config rc) {
        this.commitTemplatePath = rc.getString("commit", null, "template");
        this.i18nCommitEncoding = rc.getString("i18n", null, "commitEncoding");
        this.cleanupMode = rc.getEnum("commit", null, "cleanup", CleanupMode.DEFAULT);
        String comment = rc.getString("core", null, "commentChar");
        if (!StringUtils.isEmptyOrNull(comment)) {
            char first;
            if ("auto".equalsIgnoreCase(comment)) {
                this.autoCommentChar = true;
            } else if (comment != null && (first = comment.charAt(0)) > ' ' && first < '\u007f') {
                this.commentCharacter = first;
            }
        }
    }

    @Nullable
    public String getCommitTemplatePath() {
        return this.commitTemplatePath;
    }

    @Nullable
    public String getCommitEncoding() {
        return this.i18nCommitEncoding;
    }

    public char getCommentChar() {
        return this.commentCharacter;
    }

    public char getCommentChar(String text) {
        if (this.isAutoCommentChar()) {
            char toUse = CommitConfig.determineCommentChar(text);
            if (toUse > '\u0000') {
                return toUse;
            }
            return '#';
        }
        return this.getCommentChar();
    }

    public boolean isAutoCommentChar() {
        return this.autoCommentChar;
    }

    @NonNull
    public CleanupMode getCleanupMode() {
        return this.cleanupMode;
    }

    @NonNull
    public CleanupMode resolve(@NonNull CleanupMode mode, boolean defaultStrip) {
        if (CleanupMode.DEFAULT == mode) {
            CleanupMode defaultMode = this.getCleanupMode();
            if (CleanupMode.DEFAULT == defaultMode) {
                return defaultStrip ? CleanupMode.STRIP : CleanupMode.WHITESPACE;
            }
            return defaultMode;
        }
        return mode;
    }

    @Nullable
    public String getCommitTemplateContent(@NonNull Repository repository) throws FileNotFoundException, IOException, ConfigInvalidException {
        if (this.commitTemplatePath == null) {
            return null;
        }
        FS fileSystem = repository.getFS();
        File commitTemplateFile = this.commitTemplatePath.startsWith("~/") ? fileSystem.resolve(fileSystem.userHome(), this.commitTemplatePath.substring(2)) : fileSystem.resolve(null, this.commitTemplatePath);
        if (!commitTemplateFile.isAbsolute()) {
            commitTemplateFile = fileSystem.resolve(repository.getWorkTree().getAbsoluteFile(), this.commitTemplatePath);
        }
        Charset commitMessageEncoding = this.getEncoding();
        return RawParseUtils.decode(commitMessageEncoding, IO.readFully(commitTemplateFile));
    }

    private Charset getEncoding() throws ConfigInvalidException {
        Charset commitMessageEncoding = DEFAULT_COMMIT_MESSAGE_ENCODING;
        if (this.i18nCommitEncoding == null) {
            return null;
        }
        try {
            commitMessageEncoding = Charset.forName(this.i18nCommitEncoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidEncoding, this.i18nCommitEncoding), e);
        }
        return commitMessageEncoding;
    }

    public static String cleanText(@NonNull String text, @NonNull CleanupMode mode, char commentChar) {
        String toProcess = text;
        boolean strip = false;
        switch (mode) {
            case VERBATIM: {
                return text;
            }
            case SCISSORS: {
                String cut = commentChar + CUT;
                if (text.startsWith(cut)) {
                    return "";
                }
                int cutPos = text.indexOf("\n" + cut);
                if (cutPos < 0) break;
                toProcess = text.substring(0, cutPos + 1);
                break;
            }
            case STRIP: {
                strip = true;
                break;
            }
            case WHITESPACE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid clean-up mode " + String.valueOf(mode));
            }
        }
        StringBuilder result = new StringBuilder();
        boolean lastWasEmpty = true;
        String[] stringArray = toProcess.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.stripTrailing()).isEmpty()) {
                if (!lastWasEmpty) {
                    result.append('\n');
                    lastWasEmpty = true;
                }
            } else if (!strip || !CommitConfig.isComment(line, commentChar)) {
                lastWasEmpty = false;
                result.append(line).append('\n');
            }
            ++n2;
        }
        int bufferSize = result.length();
        if (lastWasEmpty && bufferSize > 0) {
            result.setLength(--bufferSize);
        }
        if (bufferSize > 0 && !toProcess.endsWith("\n") && result.charAt(bufferSize - 1) == '\n') {
            result.setLength(bufferSize - 1);
        }
        return result.toString();
    }

    private static boolean isComment(String text, char commentChar) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return ch == commentChar;
            }
            ++i;
        }
        return false;
    }

    public static char determineCommentChar(String text) {
        if (StringUtils.isEmptyOrNull(text)) {
            return '#';
        }
        boolean[] inUse = new boolean[127];
        Object[] objectArray = text.split("\n");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = objectArray[n2];
            int len = line.length();
            int i = 0;
            while (i < len) {
                char ch = line.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    if (ch >= inUse.length) break;
                    inUse[ch] = true;
                    break;
                }
                ++i;
            }
            ++n2;
        }
        objectArray = COMMENT_CHARS;
        n = COMMENT_CHARS.length;
        n2 = 0;
        while (n2 < n) {
            String candidate = objectArray[n2];
            if (!inUse[candidate]) {
                return (char)candidate;
            }
            ++n2;
        }
        return '\u0000';
    }

    public static enum CleanupMode implements Config.ConfigEnum
    {
        STRIP,
        WHITESPACE,
        VERBATIM,
        SCISSORS,
        DEFAULT;


        @Override
        public String toConfigValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean matchConfigValue(String in) {
            return this.toConfigValue().equals(in);
        }
    }
}

