/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsReftableBatchRefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsReftableStack;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableDatabase;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.BatchRefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.NullProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogReader;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.ReceiveCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.RefList;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.RefMap;

public class DfsReftableDatabase
extends DfsRefDatabase {
    final ReftableDatabase reftableDatabase = new ReftableDatabase(){

        @Override
        public MergedReftable openMergedReftable() throws IOException {
            ReentrantLock l = DfsReftableDatabase.this.getLock();
            l.lock();
            try {
                MergedReftable mergedReftable = new MergedReftable(DfsReftableDatabase.this.stack().readers());
                return mergedReftable;
            }
            finally {
                l.unlock();
            }
        }
    };
    private DfsReader ctx;
    private DfsReftableStack stack = null;

    protected DfsReftableDatabase(DfsRepository repo) {
        super(repo);
    }

    @Override
    public boolean hasVersioning() {
        return true;
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    public BatchRefUpdate newBatchUpdate() {
        DfsObjDatabase odb = this.getRepository().getObjectDatabase();
        return new DfsReftableBatchRefUpdate(this, odb);
    }

    public ReftableConfig getReftableConfig() {
        return new ReftableConfig(this.getRepository());
    }

    protected ReentrantLock getLock() {
        return this.reftableDatabase.getLock();
    }

    protected boolean compactDuringCommit() {
        return true;
    }

    protected DfsReftableStack stack() throws IOException {
        if (!this.getLock().isLocked()) {
            throw new IllegalStateException("most hold lock to access stack");
        }
        DfsObjDatabase odb = this.getRepository().getObjectDatabase();
        if (this.ctx == null) {
            this.ctx = odb.newReader();
        }
        if (this.stack == null) {
            this.stack = DfsReftableStack.open(this.ctx, Arrays.asList(odb.getReftables()));
        }
        return this.stack;
    }

    @Override
    public boolean isNameConflicting(String refName) throws IOException {
        return this.reftableDatabase.isNameConflicting(refName, new TreeSet<String>(), new HashSet<String>());
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        return this.reftableDatabase.exactRef(name);
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        List<Ref> refs = this.reftableDatabase.getRefsByPrefix(prefix);
        RefList.Builder<Ref> builder = new RefList.Builder<Ref>(refs.size());
        for (Ref r : refs) {
            builder.add(r);
        }
        return new RefMap(prefix, builder.toRefList(), RefList.emptyList(), RefList.emptyList());
    }

    @Override
    public List<Ref> getRefsByPrefix(String prefix) throws IOException {
        return this.reftableDatabase.getRefsByPrefix(prefix);
    }

    @Override
    public List<Ref> getRefsByPrefixWithExclusions(String include, Set<String> excludes) throws IOException {
        return this.reftableDatabase.getRefsByPrefixWithExclusions(include, excludes);
    }

    @Override
    public ReflogReader getReflogReader(Ref ref) throws IOException {
        return this.reftableDatabase.getReflogReader(ref.getName());
    }

    @Override
    public Set<Ref> getTipsWithSha1(ObjectId id) throws IOException {
        if (!this.getReftableConfig().isIndexObjects()) {
            return super.getTipsWithSha1(id);
        }
        return this.reftableDatabase.getTipsWithSha1(id);
    }

    @Override
    public boolean hasFastTipsWithSha1() throws IOException {
        return this.reftableDatabase.hasFastTipsWithSha1();
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        Ref oldLeaf = ref.getLeaf();
        if (oldLeaf.isPeeled() || oldLeaf.getObjectId() == null) {
            return ref;
        }
        return DfsReftableDatabase.recreate(ref, this.doPeel(oldLeaf), this.hasVersioning());
    }

    @Override
    boolean exists() throws IOException {
        DfsObjDatabase odb = this.getRepository().getObjectDatabase();
        return odb.getReftables().length > 0;
    }

    @Override
    void clearCache() {
        ReentrantLock l = this.getLock();
        l.lock();
        try {
            if (this.ctx != null) {
                this.ctx.close();
                this.ctx = null;
            }
            this.reftableDatabase.clearCache();
            if (this.stack != null) {
                this.stack.close();
                this.stack = null;
            }
        }
        finally {
            l.unlock();
        }
    }

    @Override
    protected boolean compareAndPut(Ref oldRef, @Nullable Ref newRef) throws IOException {
        ReceiveCommand cmd = ReftableDatabase.toCommand(oldRef, newRef);
        Throwable throwable = null;
        Object var5_6 = null;
        try (RevWalk rw = new RevWalk(this.getRepository());){
            rw.setRetainBody(false);
            this.newBatchUpdate().setAllowNonFastForwards(true).addCommand(cmd).execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        switch (cmd.getResult()) {
            case OK: {
                return true;
            }
            case REJECTED_OTHER_REASON: {
                throw new IOException(cmd.getMessage());
            }
        }
        return false;
    }

    @Override
    protected boolean compareAndRemove(Ref oldRef) throws IOException {
        return this.compareAndPut(oldRef, null);
    }

    @Override
    protected DfsRefDatabase.RefCache scanAllRefs() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void stored(Ref ref) {
    }

    @Override
    void removed(String refName) {
    }

    @Override
    protected void cachePeeledState(Ref oldLeaf, Ref newLeaf) {
    }
}

