/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph;

import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.AnyObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.NB;

class GraphObjectIndex {
    private static final int FANOUT = 256;
    private final int hashLength;
    private final int[] fanoutTable;
    private final byte[] oidLookup;
    private final long commitCnt;

    GraphObjectIndex(int hashLength, @NonNull byte[] oidFanout, @NonNull byte[] oidLookup) throws CommitGraphFormatException {
        this.hashLength = hashLength;
        this.oidLookup = oidLookup;
        int[] table = new int[256];
        int k = 0;
        while (k < table.length) {
            long uint32 = NB.decodeUInt32(oidFanout, k * 4);
            if (uint32 > Integer.MAX_VALUE) {
                throw new CommitGraphFormatException(JGitText.get().commitGraphFileIsTooLargeForJgit);
            }
            table[k] = (int)uint32;
            ++k;
        }
        this.fanoutTable = table;
        this.commitCnt = table[255];
    }

    int findGraphPosition(AnyObjectId id) {
        int levelOne = id.getFirstByte();
        int high = this.fanoutTable[levelOne];
        int low = 0;
        if (levelOne > 0) {
            low = this.fanoutTable[levelOne - 1];
        }
        while (low < high) {
            int mid = low + high >>> 1;
            int pos = this.objIdOffset(mid);
            int cmp = id.compareTo(this.oidLookup, pos);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        }
        return -1;
    }

    ObjectId getObjectId(int graphPos) {
        if (graphPos < 0 || (long)graphPos >= this.commitCnt) {
            return null;
        }
        return ObjectId.fromRaw(this.oidLookup, this.objIdOffset(graphPos));
    }

    long getCommitCnt() {
        return this.commitCnt;
    }

    private int objIdOffset(int pos) {
        return this.hashLength * pos;
    }
}

