/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.ConfigInvalidException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph.CommitGraphBuilder;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.IO;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.NB;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.SystemReader;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.io.SilentFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitGraphLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CommitGraphLoader.class);

    public static CommitGraph open(File graphFile) throws FileNotFoundException, CommitGraphFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(graphFile);){
            return CommitGraphLoader.read(fd);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static CommitGraph read(InputStream fd) throws CommitGraphFormatException, IOException {
        boolean readChangedPathFilters;
        try {
            readChangedPathFilters = SystemReader.getInstance().getJGitConfig().getBoolean("commitGraph", "readChangedPaths", false);
        }
        catch (ConfigInvalidException e) {
            readChangedPathFilters = false;
        }
        return CommitGraphLoader.read(fd, readChangedPathFilters);
    }

    public static CommitGraph read(InputStream fd, boolean readChangedPathFilters) throws CommitGraphFormatException, IOException {
        byte[] hdr = new byte[8];
        IO.readFully(fd, hdr, 0, hdr.length);
        int magic = NB.decodeInt32(hdr, 0);
        if (magic != 1128747080) {
            throw new CommitGraphFormatException(JGitText.get().notACommitGraph);
        }
        byte hashVersion = hdr[5];
        if (hashVersion != 1) {
            throw new CommitGraphFormatException(JGitText.get().incorrectOBJECT_ID_LENGTH);
        }
        byte v = hdr[4];
        if (v != 1) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().unsupportedCommitGraphVersion, v));
        }
        int numberOfChunks = hdr[6];
        byte[] lookupBuffer = new byte[12 * (numberOfChunks + 1)];
        IO.readFully(fd, lookupBuffer, 0, lookupBuffer.length);
        ArrayList<ChunkSegment> chunks = new ArrayList<ChunkSegment>(numberOfChunks + 1);
        int i = 0;
        while (i <= numberOfChunks) {
            int id = NB.decodeInt32(lookupBuffer, i * 12);
            long offset = NB.decodeInt64(lookupBuffer, i * 12 + 4);
            chunks.add(new ChunkSegment(id, offset));
            ++i;
        }
        CommitGraphBuilder builder = CommitGraphBuilder.builder();
        int i2 = 0;
        while (i2 < numberOfChunks) {
            long chunkOffset = ((ChunkSegment)chunks.get((int)i2)).offset;
            int chunkId = ((ChunkSegment)chunks.get((int)i2)).id;
            long len = ((ChunkSegment)chunks.get((int)(i2 + 1))).offset - chunkOffset;
            if (len > 0x7FFFFFF7L) {
                throw new CommitGraphFormatException(JGitText.get().commitGraphFileIsTooLargeForJgit);
            }
            byte[] buffer = new byte[(int)len];
            IO.readFully(fd, buffer, 0, buffer.length);
            switch (chunkId) {
                case 1330201670: {
                    builder.addOidFanout(buffer);
                    break;
                }
                case 1330201676: {
                    builder.addOidLookUp(buffer);
                    break;
                }
                case 1128546644: {
                    builder.addCommitData(buffer);
                    break;
                }
                case 0x45444745: {
                    builder.addExtraList(buffer);
                    break;
                }
                case 1112097880: {
                    if (!readChangedPathFilters) break;
                    builder.addBloomFilterIndex(buffer);
                    break;
                }
                case 1111769428: {
                    if (!readChangedPathFilters) break;
                    builder.addBloomFilterData(buffer);
                    break;
                }
                default: {
                    LOG.warn(MessageFormat.format(JGitText.get().commitGraphChunkUnknown, Integer.toHexString(chunkId)));
                }
            }
            ++i2;
        }
        return builder.build();
    }

    private static class ChunkSegment {
        final int id;
        final long offset;

        private ChunkSegment(int id, long offset) {
            this.id = id;
            this.offset = offset;
        }
    }
}

