/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.StoredConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.RemoteConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.URIish;

public class RemoteSetUrlCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;
    private URIish remoteUri;
    private UriType type;

    protected RemoteSetUrlCommand(Repository repo) {
        super(repo);
    }

    public RemoteSetUrlCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    public RemoteSetUrlCommand setRemoteUri(URIish remoteUri) {
        this.remoteUri = remoteUri;
        return this;
    }

    public RemoteSetUrlCommand setUriType(UriType type) {
        this.type = type;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            if (this.type == UriType.PUSH) {
                List<URIish> uris = remote.getPushURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removePushURI(uris.get(0));
                }
                remote.addPushURI(this.remoteUri);
            } else {
                List<URIish> uris = remote.getURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removeURI(uris.get(0));
                }
                remote.addURI(this.remoteUri);
            }
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public static enum UriType {
        FETCH,
        PUSH;

    }
}

