/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal.GitUtils;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal.Util;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.Git;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.annotations.Nullable;

interface GitChangelog {
    public static String generateChangelogFromTo(Git git, String repositoryUrl, boolean plainText, RevCommit start, RevCommit end, @Nullable String tagPrefix, Iterable<String> filter) throws GitAPIException, IOException {
        String endCommitHash = end.toObjectId().getName();
        String startCommitHash = start.toObjectId().getName();
        String changeLogName = Util.replace(git.getRepository().getFullBranch(), s2 -> s2.replace("refs/heads/", ""));
        Map<String, String> tagMap = GitUtils.getCommitToTagMap(git, tagPrefix);
        ArrayList<RevCommit> log = Util.toList(GitUtils.getCommitLogFromTo(git, tagMap, start, end, tagPrefix, filter));
        tagMap = Util.removePrefix(tagMap, tagPrefix);
        Map<String, String> versionMap = GitUtils.buildVersionMap(log, tagMap);
        Map<String, String> primaryVersionMap = GitUtils.getPrimaryVersionMap(log, tagMap);
        Map<String, Integer> primaryVersionPrefixLengthMap = GitUtils.determinePrefixLengthPerPrimaryVersion(versionMap.values(), new HashSet<String>(primaryVersionMap.values()));
        StringBuilder changelog = new StringBuilder();
        changelog.append(plainText ? "%s Changelog\n".formatted(changeLogName) : "### [%s Changelog](%s/compare/%s...%s)%n".formatted(changeLogName, repositoryUrl, startCommitHash, endCommitHash));
        String currentPrimaryVersion = "";
        Pattern pullRequestPattern = Pattern.compile("\\(#(?<pullNumber>[0-9]+)\\)");
        for (RevCommit commit : log) {
            Matcher matcher;
            String commitHash = commit.toObjectId().name();
            boolean requiresVersionHeader = false;
            if (primaryVersionMap.containsKey(commitHash)) {
                String versionsPrimaryVersion = primaryVersionMap.get(commitHash);
                requiresVersionHeader = !Objects.equals(versionsPrimaryVersion, currentPrimaryVersion);
                currentPrimaryVersion = versionsPrimaryVersion;
            }
            if (requiresVersionHeader && plainText) {
                changelog.append(currentPrimaryVersion).append('\n');
                changelog.append(currentPrimaryVersion.replaceAll(".", "=")).append('\n');
            }
            StringBuilder commitHeader = new StringBuilder();
            commitHeader.append(" - ");
            if (versionMap.containsKey(commitHash)) {
                String version = versionMap.get(commitHash);
                String commitHeaderVersion = "%s".formatted(GitChangelog.padRight(version, primaryVersionPrefixLengthMap.getOrDefault(currentPrimaryVersion, 0)));
                String commitHeaderUrl = "(%s/tree/%s)".formatted(repositoryUrl, version);
                commitHeader.append(tagMap.containsKey(commitHash) && !plainText ? "[%s]%s".formatted(commitHeaderVersion, commitHeaderUrl) : commitHeaderVersion);
            }
            int commitHeaderLength = commitHeader.length();
            commitHeader.append(' ');
            String noneCommitHeaderPrefix = String.join((CharSequence)"", Collections.nCopies(commitHeaderLength, " ")) + " ";
            String subject = GitUtils.processCommitBody(commit.getFullMessage().trim());
            if (!plainText && (matcher = pullRequestPattern.matcher(subject)).find()) {
                String pullRequestNumber = matcher.group("pullNumber");
                subject = subject.replace("#%s".formatted(pullRequestNumber), "[#%s](%s/pull/%s)".formatted(pullRequestNumber, repositoryUrl, pullRequestNumber));
            }
            subject = subject.replaceAll("\\n", "\n" + noneCommitHeaderPrefix);
            changelog.append((CharSequence)commitHeader).append(subject);
            changelog.append('\n');
            if (!tagMap.containsKey(commitHash) || !plainText) continue;
            changelog.append('\n');
        }
        return changelog.toString();
    }

    private static String padRight(CharSequence self, Number numberOfChars) {
        return GitChangelog.padRight(self, numberOfChars, " ");
    }

    private static String padRight(CharSequence self, Number numberOfChars, CharSequence padding) {
        int numChars = numberOfChars.intValue();
        return numChars <= self.length() ? self.toString() : String.valueOf(self) + GitChangelog.getPadding(padding.toString(), numChars - self.length());
    }

    private static String getPadding(CharSequence padding, int length) {
        return padding.length() < length ? GitChangelog.multiply(padding, length / padding.length() + 1).substring(0, length) : String.valueOf(padding.subSequence(0, length));
    }

    private static String multiply(CharSequence self, Number factor) {
        int size = factor.intValue();
        if (size == 0) {
            return "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("multiply() should be called with a number of 0 or greater not: " + size);
        }
        return String.valueOf(self) + String.valueOf(self).repeat(size - 1);
    }
}

