/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.CloneableIterator;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.EWAHCompressedBitmap32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.EWAHIterator32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.IteratingRLW32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.IteratorAggregation32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.XORIt;

class ORIt
implements CloneableIterator<EWAHIterator32> {
    final EWAHCompressedBitmap32 buffer = new EWAHCompressedBitmap32();
    final int[] hardBitmap;
    final LinkedList<IteratingRLW32> ll;

    ORIt(LinkedList<IteratingRLW32> basell, int bufSize) {
        this.ll = basell;
        this.hardBitmap = new int[bufSize];
    }

    public XORIt clone() throws CloneNotSupportedException {
        XORIt answer = (XORIt)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (int[])this.hardBitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator32 next() {
        this.buffer.clear();
        int effective = 0;
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            IteratingRLW32 rlw = (IteratingRLW32)i.next();
            if (rlw.size() > 0) {
                int eff = IteratorAggregation32.inplaceor(this.hardBitmap, rlw);
                if (eff <= effective) continue;
                effective = eff;
                continue;
            }
            i.remove();
        }
        for (int k = 0; k < effective; ++k) {
            this.buffer.addWord(this.hardBitmap[k]);
        }
        Arrays.fill(this.hardBitmap, 0);
        return this.buffer.getEWAHIterator();
    }
}

