/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.BitmapStorage;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.IteratingRLW;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.IteratorAggregation;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.LogicalElement;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static EWAHCompressedBitmap bufferedand(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedandWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    public static void bufferedandWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        void var6_9;
        LinkedList<IteratingBufferedRunningLengthWord> al = new LinkedList<IteratingBufferedRunningLengthWord>();
        EWAHCompressedBitmap[] eWAHCompressedBitmapArray = bitmaps;
        int n = eWAHCompressedBitmapArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            EWAHCompressedBitmap bitmap = eWAHCompressedBitmapArray[var6_9];
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
            ++var6_9;
        }
        long[] hardbitmap = new long[bufSize * bitmaps.length];
        for (IteratingRLW iteratingRLW : al) {
            if (iteratingRLW.size() != 0L) continue;
            al.clear();
            break;
        }
        block2: while (!al.isEmpty()) {
            Arrays.fill(hardbitmap, -1L);
            long effective = Integer.MAX_VALUE;
            for (IteratingRLW iteratingRLW : al) {
                int eff = IteratorAggregation.inplaceand(hardbitmap, iteratingRLW);
                if ((long)eff >= effective) continue;
                effective = eff;
            }
            int k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            for (IteratingRLW iteratingRLW : al) {
                if (iteratingRLW.size() != 0L) continue;
                al.clear();
                continue block2;
            }
        }
    }

    public static EWAHCompressedBitmap bufferedor(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedorWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeInBits() - a.sizeInBits();
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeInBits() > range) {
                range = bitmap.sizeInBits();
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplaceor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBitsWithinLastWord(range);
    }

    public static EWAHCompressedBitmap bufferedxor(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedxorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedxorWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeInBits() - a.sizeInBits();
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeInBits() > range) {
                range = bitmap.sizeInBits();
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplacexor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBitsWithinLastWord(range);
    }

    public static <T extends LogicalElement> T or(T ... bitmaps) {
        PriorityQueue<LogicalElement> pq = new PriorityQueue<LogicalElement>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.or(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void orToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        pq.poll().orToContainer(pq.poll(), container);
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap xor(EWAHCompressedBitmap ... bitmaps) {
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap or(Iterator<EWAHCompressedBitmap> bitmaps) {
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(32, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add(bitmaps.next());
        }
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap xor(Iterator<EWAHCompressedBitmap> bitmaps) {
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(32, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add(bitmaps.next());
        }
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    public static <T extends LogicalElement> T xor(T ... bitmaps) {
        PriorityQueue<LogicalElement> pq = new PriorityQueue<LogicalElement>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.xor(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void xorToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        pq.poll().xorToContainer(pq.poll(), container);
    }
}

