/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashStore;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.Nullable;

record ToolImpl(String getName, ModuleVersionIdentifier getModule, String artifact, String fileName, String downloadUrl, int getJavaVersion, @Nullable String getMainClass, String mavenUrl) implements ToolInternal
{
    private static final long serialVersionUID = -862411638019629688L;
    private static final Logger LOGGER = Logging.getLogger(Tool.class);

    ToolImpl(String name, String artifact, String mavenUrl, int javaVersion, @Nullable String mainClass) {
        this(name, SharedUtil.moduleOf(artifact), artifact, mavenUrl, javaVersion, mainClass);
    }

    ToolImpl(String name, SharedUtil.SimpleModuleVersionIdentifier module, String artifact, String mavenUrl, int javaVersion, @Nullable String mainClass) {
        this(name, module, artifact, module.getFileName(), module.getDownloadUrl(mavenUrl), javaVersion, mainClass, mavenUrl);
    }

    private Overrides fillOverrides(Tool.Definition definition) {
        String downloadUrl = this.downloadUrl;
        String fileName = this.fileName;
        String artifact = this.artifact;
        if (definition.getArtifact().isPresent()) {
            artifact = (String)definition.getArtifact().get();
            SharedUtil.SimpleModuleVersionIdentifier parsed = SharedUtil.moduleOf(artifact);
            downloadUrl = parsed.getDownloadUrl(this.mavenUrl);
            fileName = parsed.getFileName();
        } else if (definition.getVersion().isPresent()) {
            String version = (String)definition.getVersion().get();
            SharedUtil.SimpleModuleVersionIdentifier parsed = SharedUtil.moduleOf(artifact).withVersion(version);
            artifact = parsed.toString();
            downloadUrl = parsed.getDownloadUrl(this.mavenUrl);
            fileName = parsed.getFileName();
        }
        return new Overrides(downloadUrl, fileName, artifact);
    }

    @Override
    public Tool.Resolved get(Provider<? extends Directory> cachesDir, ProviderFactory providers, ToolsExtensionImpl toolsExt) {
        Tool.Definition definition = (Tool.Definition)toolsExt.definitions.maybeCreate(this.getName());
        ConfigurableFileCollection classpathFromGradle = toolsExt.getObjects().fileCollection();
        ConfigurableFileCollection classpathFromDownload = definition.getClasspath();
        String mainClass = (String)definition.getMainClass().orElse(providers.provider(this::getMainClass)).getOrNull();
        if (classpathFromDownload.isEmpty()) {
            Overrides overrides = this.fillOverrides(definition);
            classpathFromGradle = toolsExt.getProject().getConfigurations().detachedConfiguration(new Dependency[]{toolsExt.getDependencies().create((CharSequence)overrides.artifact)}).setTransitive(mainClass != null);
            classpathFromDownload = toolsExt.getObjects().fileCollection().from(new Object[]{providers.of(Source.class, spec -> spec.parameters(parameters -> {
                parameters.getInputFile().set(cachesDir.map(d -> d.file("tools/" + overrides.fileName)));
                parameters.getDownloadUrl().set((Object)overrides.downloadUrl);
            }))});
        }
        return new ResolvedImpl(toolsExt.getObjects(), (FileCollection)classpathFromGradle, (FileCollection)classpathFromDownload, mainClass, (Provider<? extends JavaLauncher>)definition.getJavaLauncher().orElse(providers.provider(() -> (JavaLauncher)SharedUtil.launcherForStrictly(toolsExt.getJavaToolchains(), this.getJavaVersion()).get())));
    }

    private record Overrides(String downloadUrl, String fileName, String artifact) {
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile((File)outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                try {
                    LOGGER.info("Deleting out-of-date tool: {}", (Object)name);
                    Files.deleteIfExists(outFile.toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete out-of-date tool: " + name);
                }
                LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile((File)outFile, (String)downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            public RegularFileProperty getInputFile();

            public Property<String> getDownloadUrl();
        }
    }

    final class ResolvedImpl
    implements ToolInternal.Resolved {
        private final FileCollection classpathFromGradle;
        private final FileCollection classpathFromDownload;
        @Nullable
        private final String mainClass;
        private final Property<JavaLauncher> javaLauncher;
        @Nullable
        private Boolean useGradle = null;

        private ResolvedImpl(ObjectFactory objects, FileCollection classpathFromGradle, @Nullable FileCollection classpathFromDownload, String mainClass, Provider<? extends JavaLauncher> javaLauncher) {
            this.classpathFromGradle = classpathFromGradle;
            this.classpathFromDownload = classpathFromDownload;
            this.mainClass = mainClass;
            this.javaLauncher = objects.property(JavaLauncher.class).value(javaLauncher);
        }

        @Override
        public FileCollection getClasspath() {
            if (this.useGradle == null) {
                try {
                    this.useGradle = !this.classpathFromGradle.getFiles().isEmpty();
                }
                catch (Exception e) {
                    this.useGradle = false;
                }
            }
            return this.useGradle != false ? this.classpathFromGradle : this.classpathFromDownload;
        }

        @Override
        public String getName() {
            return ToolImpl.this.getName();
        }

        @Override
        public ModuleVersionIdentifier getModule() {
            return ToolImpl.this.getModule();
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public int getJavaVersion() {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().asInt();
        }

        @Override
        @Nullable
        public String getMainClass() {
            return this.mainClass;
        }
    }

    static abstract class DefinitionImpl
    implements ToolInternal.Definition {
        private final String name;
        private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
        private final Property<String> mainClass = this.getObjects().property(String.class);
        private final Property<JavaLauncher> javaLauncher = this.getObjects().property(JavaLauncher.class);
        private final Property<String> version = this.getObjects().property(String.class);
        private final Property<String> artifact = this.getObjects().property(String.class);

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        public DefinitionImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public ConfigurableFileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public Property<String> getMainClass() {
            return this.mainClass;
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public Property<String> getVersion() {
            return this.version;
        }

        @Override
        public Property<String> getArtifact() {
            return this.artifact;
        }
    }
}

