/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shared;

import java.io.Serializable;
import java.util.concurrent.Callable;
import net.minecraftforge.gradleutils.shared.ToolImpl;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Tool
extends Named,
Serializable {
    public static Tool of(String name, String artifact, String mavenUrl, int javaVersion, @Nullable String mainClass) {
        return new ToolImpl(name, artifact, mavenUrl, javaVersion, mainClass);
    }

    public static Tool of(String name, String artifact, String mavenUrl, int javaVersion) {
        return new ToolImpl(name, artifact, mavenUrl, javaVersion, null);
    }

    public static Tool ofForge(String name, String artifact, int javaVersion, String mainClass) {
        return new ToolImpl(name, artifact, "https://maven.minecraftforge.net/", javaVersion, mainClass);
    }

    public static Tool ofForge(String name, String artifact, int javaVersion) {
        return new ToolImpl(name, artifact, "https://maven.minecraftforge.net/", javaVersion, null);
    }

    public ModuleVersionIdentifier getModule();

    public String getName();

    public int getJavaVersion();

    @Nullable
    public String getMainClass();

    default public boolean hasMainClass() {
        return this.getMainClass() != null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Resolved
    extends Tool,
    Callable<FileCollection> {
        @Override
        default public FileCollection call() {
            return this.getClasspath();
        }

        public FileCollection getClasspath();

        public Property<JavaLauncher> getJavaLauncher();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @ApiStatus.Experimental
    public static interface Definition
    extends Named {
        public Property<String> getVersion();

        public Property<String> getArtifact();

        public ConfigurableFileCollection getClasspath();

        public Property<String> getMainClass();

        public Property<JavaLauncher> getJavaLauncher();
    }
}

