/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.util.hash.HashStore;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.Nullable;

class ToolImpl
implements Tool {
    private static final Logger LOGGER = Logging.getLogger(Tool.class);
    private final String name;
    private final String version;
    private final String fileName;
    private final String downloadUrl;
    private final int javaVersion;
    @Nullable
    private final String mainClass;

    public ToolImpl(String name, String version, String fileName, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this.name = name;
        this.version = version;
        this.fileName = fileName;
        this.downloadUrl = downloadUrl;
        this.javaVersion = javaVersion;
        this.mainClass = mainClass;
    }

    ToolImpl(String name, String version, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this(name, version, String.format("%s-%s.jar", name, version), downloadUrl, javaVersion, mainClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    @Nullable
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public Provider<File> get(Provider<? extends Directory> cachesDir, ProviderFactory providers) {
        return providers.of(Source.class, spec -> spec.parameters(parameters -> {
            parameters.getInputFile().set(cachesDir.map(d -> d.file("tools/" + this.fileName)));
            parameters.getDownloadUrl().set((Object)this.downloadUrl);
        }));
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile((File)outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile((File)outFile, (String)downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            public RegularFileProperty getInputFile();

            public Property<String> getDownloadUrl();
        }
    }
}

