/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradlejarsigner;

import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradlejarsigner.GradleJarSignerExtension;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Task;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class SignTask
implements PatternFilterable {
    private final GradleJarSignerExtension ext;
    private final Zip parent;
    private final Closure<SignTask> config;
    private final Property<String> alias;
    private final Property<String> storePass;
    private final Property<String> keyPass;
    private final Property<String> keyStoreData;
    private final Property<File> keyStoreFile;
    private final PatternSet patternSet = new PatternSet();

    SignTask(GradleJarSignerExtension ext, Zip parent, Closure<SignTask> config) {
        this.ext = ext;
        this.parent = parent;
        this.config = config;
        if (this.config != null) {
            this.config.setDelegate((Object)this);
        }
        ObjectFactory objs = this.parent.getProject().getObjects();
        this.alias = objs.property(String.class);
        this.storePass = objs.property(String.class);
        this.keyPass = objs.property(String.class);
        this.keyStoreData = objs.property(String.class);
        this.keyStoreFile = objs.property(File.class);
        this.parent.configure((Closure)new Closure<Object>((Object)parent){

            public Object doCall() {
                SignTask.this.ext.fill(SignTask.this);
                if (SignTask.this.config != null) {
                    SignTask.this.config.call();
                }
                return SignTask.this.addProperties();
            }
        });
        this.parent.doLast(this::signSafe);
    }

    private Object addProperties() {
        TaskInputsInternal in = this.parent.getInputs();
        if (!this.patternSet.isEmpty()) {
            in.property("signJar.patternSet.excludes", (Object)this.patternSet.getExcludes());
            in.property("signJar.patternSet.includes", (Object)this.patternSet.getIncludes());
        }
        in.property("signJar.alias", this.alias).optional(true);
        in.property("signJar.storePass", this.storePass).optional(true);
        in.property("signJar.keyPass", this.keyPass).optional(true);
        in.property("signJar.keyStoreData", this.keyStoreData).optional(true);
        if (this.keyStoreFile.isPresent()) {
            in.file(this.keyStoreFile);
        }
        return null;
    }

    private <T extends Task> void signSafe(T task) {
        try {
            if (this.hasEnoughInfo()) {
                this.sign(task);
            } else {
                task.getLogger().warn("Jar will be unsigned, missing key information");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasEnoughInfo() {
        return this.alias.isPresent() && this.storePass.isPresent() && this.keyPass.isPresent() && (this.keyStoreData.isPresent() || this.keyStoreFile.isPresent());
    }

    private static File getTaskArchiveFile(Zip task) {
        try {
            Provider archiveFile = (Provider)Objects.requireNonNull(InvokerHelper.getProperty((Object)task, (String)"archiveFile"));
            return ((RegularFile)archiveFile.get()).getAsFile();
        }
        catch (Exception e) {
            try {
                return task.getArchivePath();
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
                throw new IllegalStateException("Could not access the parent task's output file", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Task> void sign(T task) throws IOException {
        File keyStore;
        HashMap<String, Map.Entry<byte[], Long>> ignoredStuff = new HashMap<String, Map.Entry<byte[], Long>>();
        File tmp = this.parent.getTemporaryDir();
        File output = SignTask.getTaskArchiveFile(this.parent);
        File original = new File(tmp, output.getName() + ".original");
        Files.move(output.toPath(), original.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File input = original;
        if (!this.patternSet.isEmpty()) {
            input = new File(tmp, input.getName() + ".unsigned");
            this.processInputJar(original, input, ignoredStuff);
            if (!ignoredStuff.isEmpty()) {
                output = new File(tmp, input.getName() + ".signed");
            }
        }
        if (this.keyStoreFile.isPresent()) {
            if (this.keyStoreData.isPresent()) {
                throw new IllegalStateException("Both KeyStoreFile and KeyStoreData can not be set at the same time");
            }
            keyStore = (File)this.keyStoreFile.get();
        } else if (this.keyStoreData.isPresent()) {
            byte[] data = Base64.getDecoder().decode(((String)this.keyStoreData.get()).getBytes(StandardCharsets.UTF_8));
            keyStore = new File(tmp, "keystore");
            Files.write(keyStore.toPath(), data, new OpenOption[0]);
        } else {
            throw new IllegalArgumentException("SignJar needs either a Base64 encoded KeyStore file, or a path to a KeyStore file");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alias", this.alias.get());
        map.put("storePass", this.storePass.get());
        map.put("jar", input.getAbsolutePath());
        map.put("signedJar", output.getAbsolutePath());
        map.put("keyStore", keyStore.getAbsolutePath());
        if (this.keyPass.isPresent()) {
            map.put("keypass", this.keyPass.get());
        }
        try {
            this.parent.getProject().getAnt().invokeMethod("signjar", map);
        }
        finally {
            if (!this.keyStoreFile.isPresent()) {
                keyStore.delete();
            }
        }
        if (!ignoredStuff.isEmpty()) {
            this.writeOutputJar(output, SignTask.getTaskArchiveFile(this.parent), ignoredStuff);
        }
    }

    private void processInputJar(File input, File output, final Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        final Spec spec = this.patternSet.getAsSpec();
        output.getParentFile().mkdirs();
        try (final JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(output)));){
            this.parent.getProject().zipTree((Object)input).visit(new FileVisitor(){

                public void visitDir(FileVisitDetails details) {
                    try {
                        String path = details.getPath();
                        ZipEntry entry = new ZipEntry(path.endsWith("/") ? path : path + "/");
                        outs.putNextEntry(entry);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void visitFile(FileVisitDetails details) {
                    try {
                        if (spec.isSatisfiedBy((Object)details)) {
                            ZipEntry entry = new ZipEntry(details.getPath());
                            entry.setTime(details.getLastModified());
                            outs.putNextEntry(entry);
                            details.copyTo((OutputStream)outs);
                            outs.closeEntry();
                        } else {
                            int len;
                            InputStream stream = details.open();
                            ByteArrayOutputStream tmp = new ByteArrayOutputStream(stream.available());
                            byte[] buf = new byte[256];
                            while ((len = stream.read(buf)) != -1) {
                                tmp.write(buf, 0, len);
                            }
                            byte[] data = tmp.toByteArray();
                            unsigned.put(details.getPath(), new MapEntry((Object)data, (Object)details.getLastModified()));
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void writeOutputJar(File signedJar, File outputJar, Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        ZipEntry n;
        outputJar.getParentFile().mkdirs();
        JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));
        byte[] buf = new byte[256];
        ZipFile base = new ZipFile(signedJar);
        for (ZipEntry zipEntry : Collections.list(base.entries())) {
            int len;
            if (zipEntry.isDirectory()) {
                outs.putNextEntry(zipEntry);
                continue;
            }
            n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            outs.putNextEntry(n);
            InputStream in = base.getInputStream(zipEntry);
            while ((len = in.read(buf)) != -1) {
                outs.write(buf, 0, len);
            }
            outs.closeEntry();
        }
        base.close();
        for (Map.Entry entry : unsigned.entrySet()) {
            n = new ZipEntry((String)entry.getKey());
            n.setTime((Long)((Map.Entry)entry.getValue()).getValue());
            outs.putNextEntry(n);
            outs.write((byte[])((Map.Entry)entry.getValue()).getKey());
            outs.closeEntry();
        }
        outs.close();
    }

    public void setAlias(String value) {
        this.alias.set((Object)value);
    }

    public void setStorePass(String value) {
        this.storePass.set((Object)value);
    }

    public void setKeyPass(String value) {
        this.keyPass.set((Object)value);
    }

    public void setKeyStoreData(String value) {
        this.keyStoreData.set((Object)value);
    }

    public void setKeyStoreFile(File value) {
        this.keyStoreFile.set((Object)value);
    }

    public PatternFilterable exclude(String ... arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Iterable<String> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Spec<FileTreeElement> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Closure arg0) {
        return this.patternSet.exclude(arg0);
    }

    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public PatternFilterable include(String ... arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Iterable<String> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Spec<FileTreeElement> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Closure arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable setExcludes(Iterable<String> arg0) {
        return this.patternSet.setExcludes(arg0);
    }

    public PatternFilterable setIncludes(Iterable<String> arg0) {
        return this.patternSet.setIncludes(arg0);
    }
}

