/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradlejarsigner;

import groovy.lang.Closure;
import java.io.File;
import java.util.function.Consumer;
import net.minecraftforge.gradlejarsigner.SignTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.bundling.Zip;

public class GradleJarSignerExtension {
    private final Project project;
    private String alias;
    private String storePass;
    private String keyPass;
    private String keyStoreData;
    private File keyStoreFile;

    public GradleJarSignerExtension(Project project) {
        this.project = project;
    }

    public SignTask sign(Zip task) {
        return new SignTask(this, task, null);
    }

    public SignTask sign(Zip task, Closure<SignTask> cfg) {
        return new SignTask(this, task, cfg);
    }

    public void fromEnvironmentVariables() {
        this.fromEnvironmentVariables(this.project.getName());
    }

    public void fromEnvironmentVariables(String prefix) {
        this.autoDetect(prefix);
    }

    public void autoDetect() {
        this.autoDetect(this.project.getName());
    }

    public void autoDetect(String prefix) {
        this.set(prefix, "SIGN_KEY_ALIAS", this::setAlias);
        this.set(prefix, "SIGN_KEY_PASSWORD", this::setKeyPass);
        this.set(prefix, "SIGN_KEYSTORE_PASSWORD", this::setStorePass);
        this.set(prefix, "SIGN_KEYSTORE_DATA", this::setKeyStoreData);
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public void setStorePass(String value) {
        this.storePass = value;
    }

    public void setKeyPass(String value) {
        this.keyPass = value;
    }

    public void setKeyStoreData(String value) {
        this.keyStoreData = value;
    }

    public void setKeyStoreFile(File value) {
        this.keyStoreFile = value;
    }

    void fill(SignTask task) {
        if (this.alias != null) {
            task.setAlias(this.alias);
        }
        if (this.keyPass != null) {
            task.setKeyPass(this.keyPass);
        }
        if (this.storePass != null) {
            task.setStorePass(this.storePass);
        }
        if (this.keyStoreData != null) {
            task.setKeyStoreData(this.keyStoreData);
        }
        if (this.keyStoreFile != null) {
            task.setKeyStoreFile(this.keyStoreFile);
        }
    }

    private void set(String prefix, String key, Consumer<String> prop) {
        String data = null;
        if (prefix != null && (data = (String)this.project.findProperty(prefix + '.' + key)) == null) {
            data = System.getenv(prefix + '.' + key);
        }
        if (data == null) {
            data = (String)this.project.findProperty(key);
        }
        if (data == null) {
            data = System.getenv(key);
        }
        if (data != null) {
            prop.accept(data);
        }
    }
}

