/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.util;

import java.util.Iterator;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class DeobfuscatingVersionUtils {
    private DeobfuscatingVersionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: DeobfuscatingVersionUtils. This is a utility class");
    }

    public static String adaptDeobfuscatedVersion(String version) {
        if (version.contains("_mapped_")) {
            return version.split("_mapped_")[0];
        }
        return version;
    }

    public static String adaptDeobfuscatedVersionRange(String version) {
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Invalid version range: " + version, e);
        }
        if (range.getRecommendedVersion() != null) {
            return DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(range.getRecommendedVersion().toString());
        }
        StringBuilder buf = new StringBuilder();
        Iterator i = range.getRestrictions().iterator();
        while (i.hasNext()) {
            Restriction r = (Restriction)i.next();
            buf.append(DeobfuscatingVersionUtils.adaptDeobfuscatedVersionRangeRestriction(r));
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public static String adaptDeobfuscatedVersionRangeRestriction(Restriction restriction) {
        StringBuilder buf = new StringBuilder();
        buf.append(restriction.isLowerBoundInclusive() ? (char)'[' : '(');
        if (restriction.getLowerBound() != restriction.getUpperBound()) {
            if (restriction.getLowerBound() != null) {
                buf.append(DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(restriction.getLowerBound().toString()));
            }
            buf.append(',');
            if (restriction.getUpperBound() != null) {
                buf.append(DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(restriction.getUpperBound().toString()));
            }
        } else {
            buf.append(DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(restriction.getLowerBound().toString()));
        }
        buf.append(restriction.isUpperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

