/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.util.Objects;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;

final class ExtraDependenciesHandler {
    private ExtraDependenciesHandler() {
    }

    static void handle(Project project, Scope scope, String group, String name, String artifact) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        for (SourceSet sourceSet : java.getSourceSets()) {
            Configuration configuration;
            if (ExtraDependenciesHandler.isMissingDependency(scope.getConditionConfiguration(project, sourceSet), group, name)) continue;
            ExternalModuleDependency dependency = project.getDependencyFactory().create((CharSequence)artifact);
            if (!ExtraDependenciesHandler.isMissingDependency(scope.getClasspathConfiguration(project, sourceSet), (Dependency)dependency) || (configuration = scope.getDeclarableConfiguration(project, sourceSet)) == null) continue;
            configuration.getDependencies().add((Object)dependency);
        }
    }

    private static boolean isMissingDependency(@Nullable Configuration configuration, String group, String name) {
        return configuration != null && configuration.getAllDependencies().matching(dependency -> group.equals(dependency.getGroup()) && name.equals(dependency.getName())).isEmpty();
    }

    private static boolean isMissingDependency(@Nullable Configuration configuration, Dependency dependency) {
        return configuration != null && configuration.getAllDependencies().matching(d -> Objects.equals(d.getGroup(), dependency.getGroup()) && Objects.equals(dependency.getName(), d.getName())).isEmpty();
    }

    static enum Scope {
        RUNTIME(SourceSet::getRuntimeClasspathConfigurationName, SourceSet::getRuntimeClasspathConfigurationName, SourceSet::getRuntimeOnlyConfigurationName),
        COMPILE(SourceSet::getCompileClasspathConfigurationName, SourceSet::getCompileClasspathConfigurationName, SourceSet::getCompileOnlyConfigurationName),
        ANNOTATION_PROCESSOR(SourceSet::getAnnotationProcessorConfigurationName, SourceSet::getRuntimeClasspathConfigurationName, SourceSet::getAnnotationProcessorConfigurationName);

        private final Function<SourceSet, String> classpath;
        private final Function<SourceSet, String> condition;
        private final Function<SourceSet, String> declarable;

        private Scope(Function<SourceSet, String> classpath, Function<SourceSet, String> condition, Function<SourceSet, String> declarable) {
            this.classpath = classpath;
            this.condition = condition;
            this.declarable = declarable;
        }

        @Nullable
        private Configuration getClasspathConfiguration(Project project, SourceSet sourceSet) {
            return (Configuration)project.getConfigurations().findByName(this.classpath.apply(sourceSet));
        }

        @Nullable
        private Configuration getConditionConfiguration(Project project, SourceSet sourceSet) {
            return (Configuration)project.getConfigurations().findByName(this.condition.apply(sourceSet));
        }

        @Nullable
        private Configuration getDeclarableConfiguration(Project project, SourceSet sourceSet) {
            return (Configuration)project.getConfigurations().findByName(this.declarable.apply(sourceSet));
        }
    }
}

