/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObjectSupport;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingRepo;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingVersionUtils;
import net.minecraftforge.gradle.userdev.util.DependencyRemapper;
import net.minecraftforge.gradle.userdev.util.MavenPomUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;

public class DependencyManagementExtension
extends GroovyObjectSupport {
    public static final String EXTENSION_NAME = "fg";
    private final Project project;
    private final DependencyRemapper remapper;
    private final DeobfuscatingRepo deobfuscatingRepo;
    private final ArtifactRepository repository;
    private final Property<Boolean> inheritAnnotationProcessor;

    public DependencyManagementExtension(Project project, DependencyRemapper remapper, DeobfuscatingRepo deobfuscatingRepo) {
        this.project = project;
        this.remapper = remapper;
        this.deobfuscatingRepo = deobfuscatingRepo;
        this.repository = new BaseRepo.Builder().add(deobfuscatingRepo).attach(project, "bundled_deobf_repo");
        this.inheritAnnotationProcessor = project.getObjects().property(Boolean.class).convention((Object)false);
    }

    public DeobfuscatingRepo getDeobfuscatingRepo() {
        return this.deobfuscatingRepo;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public Property<Boolean> getInheritAnnotationProcessor() {
        return this.inheritAnnotationProcessor;
    }

    public Dependency deobf(Object dependency) {
        return this.deobf(dependency, null);
    }

    public Dependency deobf(Object dependency, @DelegatesTo(value=Dependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.Dependency"}) Closure<?> configure) {
        Dependency baseDependency = this.project.getDependencies().create(dependency, configure);
        this.project.getDependencies().add("__obfuscated", (Object)baseDependency);
        return this.remapper.remap(baseDependency);
    }

    public <T> Provider<?> deobf(Provider<T> dependency) {
        return this.deobf(dependency, (Closure<?>)null);
    }

    public <T> Provider<?> deobf(Provider<T> dependency, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.ExternalModuleDependency"}) Closure<?> configure) {
        if (dependency.isPresent() && dependency.get() instanceof ExternalModuleDependencyBundle) {
            this.project.getDependencies().addProvider("__obfuscated", dependency, baseDependency -> {
                if (configure != null) {
                    configure.call(baseDependency);
                }
            });
            return this.project.getObjects().property(ExternalModuleDependencyBundle.class).value(this.project.provider(() -> {
                RemappedExternalModuleDependencyBundle newBundle = new RemappedExternalModuleDependencyBundle();
                for (MinimalExternalModuleDependency d : (ExternalModuleDependencyBundle)dependency.get()) {
                    if (configure != null) {
                        configure.call((Object)d);
                    }
                    newBundle.add((MinimalExternalModuleDependency)this.remapper.remap((Dependency)d));
                }
                return newBundle;
            }));
        }
        Property provider = this.project.getObjects().property(Dependency.class).value(dependency.map(d -> this.deobf(d, configure)));
        provider.finalizeValue();
        return provider;
    }

    public <T> Provider<?> deobf(ProviderConvertible<T> dependency) {
        return this.deobf(dependency, (Closure<?>)null);
    }

    public <T> Provider<?> deobf(ProviderConvertible<T> dependency, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.ExternalModuleDependency"}) Closure<?> configure) {
        return this.deobf(dependency.asProvider(), configure);
    }

    public MavenPublication component(MavenPublication mavenPublication) {
        this.project.getTasks().withType(GenerateModuleMetadata.class).forEach(generateModuleMetadata -> generateModuleMetadata.setEnabled(false));
        mavenPublication.suppressAllPomMetadataWarnings();
        mavenPublication.pom(pom -> pom.withXml(xml -> {
            NodeList dependencies = MavenPomUtils.getDependenciesNodeList(xml);
            List dependenciesNodeList = dependencies.stream().filter(Node.class::isInstance).map(Node.class::cast).collect(Collectors.toList());
            dependenciesNodeList.stream().filter(el -> MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}artifactId", "forge", "fmlonly") && MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}groupId", "net.minecraftforge")).forEach(el -> el.parent().remove(el));
            dependenciesNodeList.stream().filter(el -> MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}artifactId", "client", "server", "joined") && MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}groupId", "net.minecraft")).forEach(el -> el.parent().remove(el));
            dependenciesNodeList.stream().filter(el -> MavenPomUtils.hasChildWithContainedText(el, "{http://maven.apache.org/POM/4.0.0}version", "_mapped_")).forEach(el -> MavenPomUtils.setChildText(el, "{http://maven.apache.org/POM/4.0.0}version", DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(MavenPomUtils.getChildText(el, "{http://maven.apache.org/POM/4.0.0}version"))));
        }));
        return mavenPublication;
    }

    public void configureMinecraftLibraryConfiguration(Configuration configuration) {
        MinecraftExtension minecraftExtension = (MinecraftExtension)((Object)this.project.getExtensions().findByType(MinecraftExtension.class));
        if (minecraftExtension == null) {
            return;
        }
        minecraftExtension.getRuns().configureEach(runConfig -> {
            Supplier<String> librariesSupplier = () -> configuration.copyRecursive().resolve().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            Supplier<String> oldToken = runConfig.getLazyTokens().get("minecraft_classpath");
            if (oldToken == null) {
                runConfig.lazyToken("minecraft_classpath", librariesSupplier);
            } else {
                runConfig.lazyToken("minecraft_classpath", () -> {
                    String existing = (String)oldToken.get();
                    String candidate = (String)librariesSupplier.get();
                    return candidate.trim().isEmpty() ? existing : existing + File.pathSeparator + candidate;
                });
            }
        });
    }

    private static class RemappedExternalModuleDependencyBundle
    extends ArrayList<MinimalExternalModuleDependency>
    implements ExternalModuleDependencyBundle {
        private RemappedExternalModuleDependencyBundle() {
        }
    }
}

