/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.patcher.PatcherExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateUserdevConfig
extends DefaultTask {
    private final NamedDomainObjectContainer<RunConfig> runs;
    @Nullable
    private UserdevConfigV2.DataFunction processor;
    private final MapProperty<String, File> processorData;
    private final Property<String> sourceFileEncoding;
    private final ListProperty<String> extraRuntimeDeps;
    private final ListProperty<String> extraCompileDeps;
    private final ListProperty<String> extraAnnotationProcessorDeps;
    private boolean notchObf = false;

    @Inject
    public GenerateUserdevConfig(Project project) {
        this.runs = project.container(RunConfig.class, name -> new RunConfig(project, name));
        ObjectFactory objects = project.getObjects();
        this.getPatchesOriginalPrefix().convention((Object)"a/");
        this.getPatchesModifiedPrefix().convention((Object)"b/");
        this.sourceFileEncoding = project.getObjects().property(String.class).convention((Object)StandardCharsets.UTF_8.name());
        this.getInject().convention((Object)"inject/");
        this.getPatches().convention((Object)"patches/");
        this.processorData = objects.mapProperty(String.class, File.class);
        this.extraRuntimeDeps = objects.listProperty(String.class);
        this.extraCompileDeps = objects.listProperty(String.class);
        this.extraAnnotationProcessorDeps = objects.listProperty(String.class);
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(d -> d.file("output.json")));
    }

    @TaskAction
    public void apply() throws IOException {
        UserdevConfigV2 json = new UserdevConfigV2();
        json.spec = this.isV2() ? 2 : 1;
        json.binpatches = "joined.lzma";
        json.sources = (String)this.getSource().get();
        json.universal = (String)this.getUniversal().get();
        json.patches = (String)this.getPatches().get();
        json.inject = (String)this.getInject().get();
        if (json.inject.isEmpty()) {
            json.inject = null;
        }
        ((List)this.getLibraries().get()).forEach(json::addLibrary);
        ((List)this.getModules().get()).forEach(json::addModule);
        this.getATs().forEach(at -> json.addAT("ats/" + at.getName()));
        this.getSASs().forEach(at -> json.addSAS("sas/" + at.getName()));
        this.getSRGs().forEach(srg -> json.addSRG("srgs/" + srg.getName()));
        ((List)this.getSRGLines().get()).forEach(json::addSRG);
        this.addParent(json, this.getProject());
        this.runs.getAsMap().forEach(json::addRun);
        json.binpatcher = new MCPConfigV1.Function();
        json.binpatcher.setVersion((String)this.getTool().get());
        json.binpatcher.setArgs((List)this.getArguments().get());
        if (this.isV2()) {
            json.processor = this.processor;
            json.patchesOriginalPrefix = (String)this.getPatchesOriginalPrefix().get();
            json.patchesModifiedPrefix = (String)this.getPatchesModifiedPrefix().get();
            json.setNotchObf(this.notchObf);
            json.setSourceFileCharset((String)this.getSourceFileEncoding().get());
            ((List)this.getUniversalFilters().get()).forEach(json::addUniversalFilter);
            json.extraDependencies = new UserdevConfigV2.ScopedDependencies();
            json.extraDependencies.compileOnly = new ArrayList<String>((Collection)this.getExtraCompileDeps().get());
            json.extraDependencies.runtimeOnly = new ArrayList<String>((Collection)this.getExtraRuntimeDeps().get());
            json.extraDependencies.annotationProcessor = new ArrayList<String>((Collection)this.getExtraAnnotationProcessorDeps().get());
        }
        Files.write((byte[])Utils.GSON.toJson((Object)json).getBytes(StandardCharsets.UTF_8), (File)((RegularFile)this.getOutput().get()).getAsFile());
    }

    private void addParent(UserdevConfigV1 json, Project project) {
        PatcherExtension patcher = (PatcherExtension)((Object)project.getExtensions().findByType(PatcherExtension.class));
        MCPExtension mcp = (MCPExtension)project.getExtensions().findByType(MCPExtension.class);
        if (patcher != null) {
            if (project != this.getProject() && patcher.getPatches().isPresent() && json.parent == null) {
                json.parent = String.format("%s:%s:%s:userdev", project.getGroup(), project.getName(), project.getVersion());
                return;
            }
            if (patcher.getParent().isPresent()) {
                this.addParent(json, (Project)patcher.getParent().get());
            }
        } else if (json.parent == null) {
            if (mcp == null) {
                throw new IllegalStateException("Could not determine MCP parent for userdev config");
            }
            json.mcp = ((Artifact)mcp.getConfig().get()).toString();
        }
    }

    private boolean isV2() {
        return this.notchObf || this.processor != null || this.getUniversalFilters().isPresent() || !"a/".equals(this.getPatchesOriginalPrefix().get()) || !"b/".equals(this.getPatchesModifiedPrefix().get());
    }

    @Input
    public abstract ListProperty<String> getLibraries();

    @Input
    public abstract ListProperty<String> getModules();

    @Input
    public abstract Property<String> getUniversal();

    @Input
    public abstract Property<String> getSource();

    @Input
    public abstract Property<String> getTool();

    @Input
    @Optional
    public abstract Property<String> getInject();

    @Input
    @Optional
    public abstract Property<String> getPatches();

    @Input
    public abstract ListProperty<String> getArguments();

    @InputFiles
    public abstract ConfigurableFileCollection getATs();

    @InputFiles
    public abstract ConfigurableFileCollection getSASs();

    @InputFiles
    public abstract ConfigurableFileCollection getSRGs();

    @Input
    @Optional
    public abstract ListProperty<String> getSRGLines();

    private static String depToString(Dependency value) {
        String group = value.getGroup();
        if (group == null) {
            throw new IllegalArgumentException("Dependency group cannot be null");
        }
        String version = value.getVersion();
        if (version == null) {
            throw new IllegalArgumentException("Dependency version cannot be null");
        }
        return group + ':' + value.getName() + ':' + version;
    }

    @Input
    @Optional
    public ListProperty<String> getExtraCompileDeps() {
        return this.extraCompileDeps;
    }

    public final void addCompileDependency(Dependency value) {
        this.getExtraCompileDeps().add((Object)GenerateUserdevConfig.depToString(value));
    }

    public final void addCompileDependency(Provider<? extends Dependency> value) {
        this.addCompileDependency((Dependency)value.get());
    }

    public final void addCompileDependency(ProviderConvertible<? extends Dependency> value) {
        this.addCompileDependency((Provider<? extends Dependency>)value.asProvider());
    }

    @Input
    @Optional
    public ListProperty<String> getExtraRuntimeDeps() {
        return this.extraRuntimeDeps;
    }

    public final void addRuntimeDependency(Dependency value) {
        this.getExtraRuntimeDeps().add((Object)GenerateUserdevConfig.depToString(value));
    }

    public final void addRuntimeDependency(Provider<? extends Dependency> value) {
        this.addRuntimeDependency((Dependency)value.get());
    }

    public final void addRuntimeDependency(ProviderConvertible<? extends Dependency> value) {
        this.addRuntimeDependency((Provider<? extends Dependency>)value.asProvider());
    }

    @Input
    @Optional
    public ListProperty<String> getExtraAnnotationProcessorDeps() {
        return this.extraAnnotationProcessorDeps;
    }

    public final void addAnnotationProcessorDependency(Dependency value) {
        this.getExtraAnnotationProcessorDeps().add((Object)GenerateUserdevConfig.depToString(value));
    }

    public final void addAnnotationProcessorDependency(Provider<? extends Dependency> value) {
        this.addAnnotationProcessorDependency((Dependency)value.get());
    }

    public final void addAnnotationProcessorDependency(ProviderConvertible<? extends Dependency> value) {
        this.addAnnotationProcessorDependency((Provider<? extends Dependency>)value.asProvider());
    }

    public NamedDomainObjectContainer<RunConfig> runs(Closure closure) {
        return this.runs.configure(closure);
    }

    @Input
    public NamedDomainObjectContainer<RunConfig> getRuns() {
        return this.runs;
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name);
        }
        Closure closure = (Closure)value;
        RunConfig runConfig = (RunConfig)this.getRuns().maybeCreate(name);
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)runConfig);
        closure.call();
    }

    private UserdevConfigV2.DataFunction ensureProcessor() {
        if (this.processor == null) {
            this.processor = new UserdevConfigV2.DataFunction();
        }
        return this.processor;
    }

    public void setProcessor(UserdevConfigV2.DataFunction value) {
        this.ensureProcessor();
        this.processor.setVersion(value.getVersion());
        this.processor.setRepo(value.getRepo());
        this.processor.setArgs(value.getArgs());
        this.processor.setJvmArgs(value.getJvmArgs());
    }

    @Input
    @Optional
    @Nullable
    public String getProcessorTool() {
        return this.processor == null ? null : this.processor.getVersion();
    }

    public void setProcessorTool(String value) {
        this.ensureProcessor().setVersion(value);
    }

    @Input
    @Optional
    @Nullable
    public String getProcessorRepo() {
        return this.processor == null ? null : this.processor.getRepo();
    }

    public void setProcessorRepo(String value) {
        this.ensureProcessor().setRepo(value);
    }

    @Input
    @Optional
    @Nullable
    public List<String> getProcessorArgs() {
        return this.processor == null ? null : this.processor.getArgs();
    }

    public void setProcessorTool(String ... values) {
        this.ensureProcessor().setArgs(Arrays.asList(values));
    }

    @InputFiles
    @Optional
    public Provider<Collection<File>> getProcessorFiles() {
        return this.processorData.map(Map::values);
    }

    public void addProcessorData(String key, File file) {
        this.processorData.put((Object)key, (Object)file);
        this.ensureProcessor().setData(key, "processor/" + file.getName());
    }

    @Input
    @Optional
    public abstract Property<String> getPatchesOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getPatchesModifiedPrefix();

    @Input
    public boolean getNotchObf() {
        return this.notchObf;
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value;
    }

    @Input
    public Property<String> getSourceFileEncoding() {
        return this.sourceFileEncoding;
    }

    public void setSourceFileEncoding(Charset value) {
        this.getSourceFileEncoding().set((Object)value.name());
    }

    public void setSourceFileEncoding(String value) {
        this.setSourceFileEncoding(Charset.forName(value));
    }

    @Input
    @Optional
    public abstract ListProperty<String> getUniversalFilters();

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

