/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.srgutils.IMappingFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class FilterNewJar
extends DefaultTask {
    public FilterNewJar() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(d -> d.file("output.jar")));
    }

    @TaskAction
    public void apply() throws IOException {
        HashSet filter = new HashSet();
        for (File file : this.getBlacklist()) {
            ZipFile zip = new ZipFile(file);
            Throwable throwable = null;
            try {
                Utils.forZip(zip, entry -> filter.add(entry.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zip == null) continue;
                if (throwable != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                zip.close();
            }
        }
        Set classes = IMappingFile.load((File)((RegularFile)this.getSrg().get()).getAsFile()).getClasses().stream().map(IMappingFile.INode::getMapped).collect(Collectors.toSet());
        try (ZipFile zin = new ZipFile(((RegularFile)this.getInput().get()).getAsFile());
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile()));){
            Utils.forZip(zin, entry -> {
                if (entry.isDirectory() || filter.contains(entry.getName()) || entry.getName().endsWith(".class") && this.isVanilla(classes, entry.getName().substring(0, entry.getName().length() - 6))) {
                    return;
                }
                out.putNextEntry(Utils.getStableEntry(entry.getName()));
                IOUtils.copy((InputStream)zin.getInputStream((ZipEntry)entry), (OutputStream)out);
                out.closeEntry();
            });
        }
    }

    private boolean isVanilla(Set<String> classes, String cls) {
        int idx = cls.indexOf(36);
        if (idx != -1) {
            return this.isVanilla(classes, cls.substring(0, idx));
        }
        return classes.contains(cls);
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @InputFile
    public abstract RegularFileProperty getSrg();

    @InputFiles
    public abstract ConfigurableFileCollection getBlacklist();

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

