/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.gradle.api.file.FileCollection;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.Nullable;

class ExecuteFunction
implements MCPFunction {
    private static final Pattern REPLACE_PATTERN = Pattern.compile("^\\{(\\w+)\\}$");
    protected final File jar;
    protected final String[] jvmArgs;
    protected String[] runArgs;
    protected final Map<String, String> envVars;
    @Nullable
    private Integer javaVersion;
    private Map<String, String> data;

    public ExecuteFunction(File jar, String[] jvmArgs, String[] runArgs, Map<String, String> envVars) {
        this(jar, jvmArgs, runArgs, envVars, null);
    }

    public ExecuteFunction(File jar, String[] jvmArgs, String[] runArgs, Map<String, String> envVars, @Nullable Integer javaVersion) {
        this.jar = jar;
        this.jvmArgs = jvmArgs;
        this.runArgs = runArgs;
        this.envVars = envVars;
        this.javaVersion = javaVersion;
    }

    @Override
    public void loadData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public void initialize(MCPEnvironment environment, ZipFile zip) throws IOException {
        this.analyzeAndExtract(environment, zip, this.jvmArgs);
        this.analyzeAndExtract(environment, zip, this.runArgs);
    }

    @Override
    public File execute(MCPEnvironment environment) throws IOException, InterruptedException, ExecutionException {
        Map<String, Object> arguments = environment.getArguments();
        String outputExtension = (String)arguments.getOrDefault("outputExtension", "jar");
        arguments.computeIfAbsent("output", k -> environment.getFile("output." + outputExtension));
        arguments.computeIfAbsent("log", k -> environment.getFile("log.log"));
        File output = (File)environment.getArguments().get("output");
        HashMap<String, Object> replacedArgs = new HashMap<String, Object>();
        List<String> jvmArgList = this.applyVariableSubstitutions(environment, Arrays.asList(this.jvmArgs), arguments, replacedArgs);
        List<String> runArgList = this.applyVariableSubstitutions(environment, Arrays.asList(this.runArgs), arguments, replacedArgs);
        replacedArgs.remove("output");
        replacedArgs.remove("log");
        HashStore hashStore = new HashStore(environment.project).load(environment.getFile("lastinput.sha1"));
        hashStore.add("args", String.join((CharSequence)" ", this.runArgs));
        hashStore.add("jvmargs", String.join((CharSequence)" ", this.jvmArgs));
        hashStore.add("jar", this.jar);
        replacedArgs.forEach((key, value) -> {
            if (value instanceof File) {
                hashStore.add((String)key, (File)value);
            } else if (value instanceof String) {
                hashStore.add((String)key, (String)value);
            }
        });
        this.addInputs(hashStore);
        if (hashStore.isSame() && output.exists()) {
            return output;
        }
        if (output.exists()) {
            output.delete();
        }
        File workingDir = environment.getWorkingDir();
        workingDir.mkdirs();
        JarFile jarFile = new JarFile(this.jar);
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        jarFile.close();
        JavaToolchainService toolchainService = (JavaToolchainService)environment.project.getExtensions().getByType(JavaToolchainService.class);
        JavaLanguageVersion toolchainVersion = this.javaVersion != null ? JavaLanguageVersion.of((int)this.javaVersion) : environment.getJavaVersion();
        String launcher = ((JavaLauncher)toolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Object)toolchainVersion)).get()).getExecutablePath().getAsFile().getAbsolutePath();
        try (BufferedOutputStream log_out = new BufferedOutputStream(new FileOutputStream(environment.getFile("console.log")));){
            environment.project.javaexec(java -> {
                PrintWriter writer = new PrintWriter(log_out);
                Function<String, String> quote = s -> '\"' + s + '\"';
                writer.println("JVM:         " + launcher);
                writer.println("JVM Args:    " + jvmArgList.stream().map(quote).collect(Collectors.joining(", ")));
                writer.println("Run Args:    " + runArgList.stream().map(quote).collect(Collectors.joining(", ")));
                writer.println("Classpath:   " + this.jar.getAbsolutePath());
                writer.println("Working Dir: " + workingDir.getAbsolutePath());
                writer.println("Main Class:  " + mainClass);
                writer.flush();
                java.executable((Object)launcher);
                java.setJvmArgs(jvmArgList);
                java.setArgs(runArgList);
                java.setClasspath((FileCollection)environment.project.files(new Object[]{this.jar}));
                java.setWorkingDir(workingDir);
                java.getMainClass().set((Object)mainClass);
                java.setStandardOutput((OutputStream)log_out);
            }).rethrowFailure().assertNormalExitValue();
        }
        hashStore.save();
        return output;
    }

    private List<String> applyVariableSubstitutions(MCPEnvironment environment, List<String> list, Map<String, Object> arguments, Map<String, Object> inputs) {
        return list.stream().map(s -> this.applyVariableSubstitutions(environment, (String)s, arguments, inputs)).collect(Collectors.toList());
    }

    private String applyVariableSubstitutions(MCPEnvironment environment, String value, Map<String, Object> arguments, Map<String, Object> inputs) {
        Matcher matcher = REPLACE_PATTERN.matcher(value);
        if (!matcher.find()) {
            return value;
        }
        String argName = matcher.group(1);
        if (argName != null) {
            Object argument = arguments.get(argName);
            if (argument instanceof File) {
                inputs.put(argName, argument);
                return ((File)argument).getAbsolutePath();
            }
            if (argument instanceof String) {
                inputs.put(argName, argument);
                return (String)argument;
            }
            String dataElement = this.data.get(argName);
            if (dataElement != null) {
                inputs.put(argName, environment.getFile(dataElement));
                return dataElement;
            }
        }
        throw new IllegalStateException("The string '" + value + "' did not return a valid substitution match!");
    }

    private void analyzeAndExtract(MCPEnvironment environment, ZipFile zip, String[] args) throws IOException {
        for (String arg : args) {
            ZipEntry entry;
            String referencedData;
            String argName;
            Matcher matcher = REPLACE_PATTERN.matcher(arg);
            if (!matcher.find() || (argName = matcher.group(1)) == null || (referencedData = this.data.get(argName)) == null || (entry = zip.getEntry(referencedData)) == null) continue;
            String entryName = entry.getName();
            if (entry.isDirectory()) {
                Utils.extractDirectory(environment::getFile, zip, entryName);
                continue;
            }
            Utils.extractFile(zip, entry, environment.getFile(entryName));
        }
    }

    protected void addInputs(HashStore cache) {
    }
}

