/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EclipseRunGenerator
extends RunConfigGenerator.XMLConfigurationBuilder {
    @Override
    protected Map<String, Document> createRunConfiguration(MinecraftExtension mc, Project project, RunConfig runConfig, DocumentBuilder documentBuilder, List<String> additionalClientArgs, FileCollection minecraftArtifacts, FileCollection runtimeClasspathArtifacts) {
        boolean prepareRun;
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>();
        Map<String, Supplier<String>> updatedTokens = EclipseRunGenerator.configureTokensLazy(project, runConfig, EclipseRunGenerator.mapModClassesToEclipse(project, runConfig), minecraftArtifacts, runtimeClasspathArtifacts);
        Document javaDocument = documentBuilder.newDocument();
        Element rootElement = javaDocument.createElement("launchConfiguration");
        rootElement.setAttribute("type", "org.eclipse.jdt.launching.localJavaApplication");
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROJECT_ATTR", EclipseRunGenerator.getEclipseProjectName(project));
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.MAIN_TYPE", runConfig.getMain());
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.VM_ARGUMENTS", EclipseRunGenerator.getJvmArgs(runConfig, additionalClientArgs, updatedTokens));
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", EclipseRunGenerator.getArgs(runConfig, updatedTokens));
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.WORKING_DIRECTORY", runConfig.getWorkingDirectory());
        Element envs = javaDocument.createElement("mapAttribute");
        envs.setAttribute("key", "org.eclipse.debug.core.environmentVariables");
        runConfig.getEnvironment().forEach((name, value) -> {
            Element envEntry = javaDocument.createElement("mapEntry");
            envEntry.setAttribute("key", (String)name);
            envEntry.setAttribute("value", runConfig.replace(updatedTokens, (String)value));
            envs.appendChild(envEntry);
        });
        rootElement.appendChild(envs);
        javaDocument.appendChild(rootElement);
        String configName = (mc.getGenerateRunFolders().get() == Boolean.TRUE ? runConfig.getFolderName() + " - " : "") + runConfig.getTaskName() + ".launch";
        boolean copyResources = mc.getCopyIdeResources().get() == Boolean.TRUE;
        boolean bl = prepareRun = mc.getEnableEclipsePrepareRuns().get() == Boolean.TRUE;
        if (copyResources || prepareRun) {
            Task copyTask;
            String launchConfigName = project.getName() + " - " + runConfig.getTaskName() + "Slim";
            documents.put(".eclipse/configurations/" + launchConfigName + ".launch", javaDocument);
            Document gradleDocument = documentBuilder.newDocument();
            Element rootElement2 = gradleDocument.createElement("launchConfiguration");
            rootElement2.setAttribute("type", "org.eclipse.buildship.core.launch.runconfiguration");
            EclipseRunGenerator.elementAttribute(gradleDocument, rootElement2, "string", "gradle_distribution", "GRADLE_DISTRIBUTION(WRAPPER)");
            EclipseRunGenerator.elementAttribute(gradleDocument, rootElement2, "boolean", "offline_mode", project.getGradle().getStartParameter().isOffline());
            EclipseRunGenerator.elementAttribute(gradleDocument, rootElement2, "boolean", "show_console_view", "true");
            EclipseRunGenerator.elementAttribute(gradleDocument, rootElement2, "boolean", "show_execution_view", "true");
            EclipseRunGenerator.elementAttribute(gradleDocument, rootElement2, "string", "working_dir", project.getRootDir());
            Element tasks = gradleDocument.createElement("listAttribute");
            tasks.setAttribute("key", "tasks");
            if (prepareRun) {
                Element prepareRunTaskEntry = gradleDocument.createElement("listEntry");
                prepareRunTaskEntry.setAttribute("value", project.getTasks().getByName(runConfig.getPrepareTaskName()).getPath());
                tasks.appendChild(prepareRunTaskEntry);
            }
            if (copyResources && (copyTask = (Task)project.getTasks().findByName("copyEclipseResources")) != null) {
                Element copyResourcesTaskEntry = gradleDocument.createElement("listEntry");
                copyResourcesTaskEntry.setAttribute("value", copyTask.getPath());
                tasks.appendChild(copyResourcesTaskEntry);
            }
            rootElement2.appendChild(tasks);
            gradleDocument.appendChild(rootElement2);
            String gradleConfigName = project.getName() + " - prepare" + Utils.capitalize(runConfig.getTaskName());
            documents.put(".eclipse/configurations/" + gradleConfigName + ".launch", gradleDocument);
            Document groupDocument = documentBuilder.newDocument();
            Element rootElement3 = groupDocument.createElement("launchConfiguration");
            rootElement3.setAttribute("type", "org.eclipse.debug.core.groups.GroupLaunchConfigurationType");
            ImmutableList configurations = ImmutableList.of((Object)new SubTaskConfiguration(gradleConfigName, SubTaskConfiguration.Mode.RUN), (Object)new SubTaskConfiguration(launchConfigName, SubTaskConfiguration.Mode.INHERIT));
            for (int i = 0; i < configurations.size(); ++i) {
                SubTaskConfiguration config = (SubTaskConfiguration)configurations.get(i);
                EclipseRunGenerator.elementAttribute(groupDocument, rootElement3, "string", "org.eclipse.debug.core.launchGroup." + i + ".action", "NONE");
                EclipseRunGenerator.elementAttribute(groupDocument, rootElement3, "boolean", "org.eclipse.debug.core.launchGroup." + i + ".adoptIfRunning", false);
                EclipseRunGenerator.elementAttribute(groupDocument, rootElement3, "boolean", "org.eclipse.debug.core.launchGroup." + i + ".enabled", true);
                EclipseRunGenerator.elementAttribute(groupDocument, rootElement3, "string", "org.eclipse.debug.core.launchGroup." + i + ".mode", (Object)config.mode);
                EclipseRunGenerator.elementAttribute(groupDocument, rootElement3, "string", "org.eclipse.debug.core.launchGroup." + i + ".name", config.name);
            }
            groupDocument.appendChild(rootElement3);
            documents.put(configName, groupDocument);
        } else {
            documents.put(configName, javaDocument);
        }
        return documents;
    }

    static String getEclipseProjectName(Project project) {
        EclipseModel eclipse = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
        return eclipse == null ? project.getName() : eclipse.getProject().getName();
    }

    static Stream<String> mapModClassesToEclipse(Project project, RunConfig runConfig) {
        IdentityHashMap sourceSetsToOutputs = new IdentityHashMap();
        project.getRootProject().getAllprojects().forEach(proj -> {
            EclipseModel eclipse = (EclipseModel)proj.getExtensions().findByType(EclipseModel.class);
            if (eclipse == null) {
                return;
            }
            EclipseClasspath classpath = eclipse.getClasspath();
            Map<String, String> outputs = classpath.resolveDependencies().stream().filter(SourceFolder.class::isInstance).map(SourceFolder.class::cast).map(SourceFolder::getOutput).distinct().collect(Collectors.toMap(output -> output.split("/")[output.split("/").length - 1], output -> proj.file(output).getAbsolutePath()));
            JavaPluginExtension javaPlugin = (JavaPluginExtension)proj.getExtensions().findByType(JavaPluginExtension.class);
            if (javaPlugin != null) {
                for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                    sourceSetsToOutputs.computeIfAbsent(sourceSet, a -> new HashMap()).putAll(outputs);
                }
            }
        });
        if (runConfig.getMods().isEmpty()) {
            return runConfig.getAllSources().stream().map(sourceSet -> (String)sourceSetsToOutputs.getOrDefault(sourceSet, Collections.emptyMap()).get(sourceSet.getName())).filter(Objects::nonNull).map(s -> String.join((CharSequence)File.pathSeparator, s, s));
        }
        SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        return runConfig.getMods().stream().flatMap(modConfig -> (modConfig.getSources().isEmpty() ? Stream.of(main) : modConfig.getSources().stream()).map(sourceSet -> (String)sourceSetsToOutputs.getOrDefault(sourceSet, Collections.emptyMap()).get(sourceSet.getName())).filter(Objects::nonNull).map(output -> modConfig.getName() + "%%" + output).map(s -> String.join((CharSequence)File.pathSeparator, s, s)));
    }

    private static final class SubTaskConfiguration {
        public final String name;
        public final Mode mode;

        private SubTaskConfiguration(String name, Mode mode) {
            this.name = name;
            this.mode = mode;
        }

        private static enum Mode {
            PROFILE,
            INHERIT,
            DEBUG,
            RUN,
            COVERAGE;


            public String toString() {
                return super.toString().toLowerCase(Locale.ROOT);
            }
        }
    }
}

