/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.ByteArrayOutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class POMBuilder {
    private static final Pattern PATTERN_ARTIFACT = Pattern.compile("^(?<group>[^:]+):(?<name>[^:]+)(?::(?<version>[^:@]+))(?::(?<classifier>[^:@]+))?(?:@(?<extension>[^:]+))?$");
    private final String group;
    private final String name;
    private final String version;
    private final Dependencies dependencies = new Dependencies();
    @Nullable
    private String description;

    public POMBuilder(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public POMBuilder description(String description) {
        this.description = description;
        return this;
    }

    public POMBuilder dependencies(Consumer<Dependencies> configurator) {
        configurator.accept(this.dependencies);
        return this;
    }

    public Dependencies dependencies() {
        return this.dependencies;
    }

    @Nullable
    public String tryBuild() {
        try {
            return this.build();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String build() throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element project = doc.createElement("project");
        project.setAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        project.setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.appendChild(project);
        POMBuilder.set(doc, project, "modelVersion", "4.0.0");
        POMBuilder.set(doc, project, "groupId", this.group);
        POMBuilder.set(doc, project, "artifactId", this.name);
        POMBuilder.set(doc, project, "version", this.version);
        POMBuilder.set(doc, project, "name", this.name);
        if (this.description != null) {
            POMBuilder.set(doc, project, "description", this.description);
        }
        if (!this.dependencies.dependencies.isEmpty()) {
            Element dependencies = doc.createElement("dependencies");
            for (Dependencies.Dependency dependency : this.dependencies.dependencies) {
                Element dep = doc.createElement("dependency");
                POMBuilder.set(doc, dep, "groupId", dependency.group);
                POMBuilder.set(doc, dep, "artifactId", dependency.name);
                POMBuilder.set(doc, dep, "version", dependency.version);
                if (dependency.classifier != null && !"jar".equals(dependency.classifier)) {
                    POMBuilder.set(doc, dep, "classifier", dependency.classifier);
                }
                if (dependency.extension != null) {
                    POMBuilder.set(doc, dep, "type", dependency.extension);
                }
                if (dependency.scope != null) {
                    POMBuilder.set(doc, dep, "scope", dependency.scope);
                }
                dependencies.appendChild(dep);
            }
            project.appendChild(dependencies);
        }
        doc.normalizeDocument();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        transformer.transform(source, result);
        return baos.toString();
    }

    private static void set(Document doc, Element parent, String name, String value) {
        Element description = doc.createElement(name);
        description.appendChild(doc.createTextNode(value));
        parent.appendChild(description);
    }

    public class Dependencies {
        private final Set<Dependency> dependencies = new LinkedHashSet<Dependency>();

        private Dependencies() {
        }

        public Dependency add(String artifact, @Nullable String scope) {
            Matcher matcher = PATTERN_ARTIFACT.matcher(artifact);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid maven artifact specifier: " + artifact);
            }
            return this.add(matcher.group("group"), matcher.group("name"), matcher.group("version"), matcher.group("classifier"), matcher.group("extension"), scope);
        }

        public Dependency addHard(String artifact, @Nullable String scope) {
            Matcher matcher = PATTERN_ARTIFACT.matcher(artifact);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid maven artifact specifier: " + artifact);
            }
            return this.add(matcher.group("group"), matcher.group("name"), '[' + matcher.group("version") + ']', matcher.group("classifier"), matcher.group("extension"), scope);
        }

        public Dependency add(String group, String name, String version, @Nullable String classifier, @Nullable String extension, @Nullable String scope) {
            Dependency dep = new Dependency(group, name, version, classifier, extension, scope);
            this.dependencies.add(dep);
            return dep;
        }

        public class Dependency {
            private final String group;
            private final String name;
            private final String version;
            @Nullable
            private String classifier;
            @Nullable
            private String extension;
            @Nullable
            private String scope;

            private Dependency(String group, String name, @Nullable String version, @Nullable String classifier, @Nullable String extension, String scope) {
                this.group = group;
                this.name = name;
                this.version = version;
                this.classifier = classifier;
                this.extension = extension;
                this.scope = scope;
            }

            public void withClassifier(@Nullable String classifier) {
                this.classifier = classifier;
            }
        }
    }
}

