/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;

public class EclipseHacks {
    public static void doEclipseFixes(MinecraftExtension minecraft, TaskProvider<ExtractNatives> nativesTask, TaskProvider<?> prepareRuns) {
        Project project = minecraft.getProject();
        Provider natives = nativesTask.flatMap(s -> s.getOutput().getAsFile());
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().findByName("eclipse");
        if (eclipseConv == null) {
            return;
        }
        XmlFileContentMerger classpathMerger = eclipseConv.getClasspath().getFile();
        String LIB_ATTR = "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
        project.getTasks().withType(GenerateEclipseClasspath.class).configureEach(task -> task.dependsOn(new Object[]{nativesTask, prepareRuns}));
        classpathMerger.whenMerged(obj -> {
            Classpath classpath = (Classpath)obj;
            HashSet<String> paths = new HashSet<String>();
            Iterator itr = classpath.getEntries().iterator();
            while (itr.hasNext()) {
                ClasspathEntry entry = (ClasspathEntry)itr.next();
                if (!(entry instanceof SourceFolder)) continue;
                SourceFolder sf = (SourceFolder)entry;
                if (!paths.add(sf.getPath())) {
                    itr.remove();
                    continue;
                }
                if (sf.getEntryAttributes().containsKey("org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY")) continue;
                sf.getEntryAttributes().put("org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", ((File)natives.get()).getAbsolutePath());
            }
        });
    }
}

