/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.Nullable;

public class Artifact
implements ArtifactIdentifier,
Comparable<Artifact>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String group;
    private final String name;
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String ext;
    @Nullable
    private transient String path;
    @Nullable
    private transient String file;
    @Nullable
    private transient String fullDescriptor;
    @Nullable
    private transient ComparableVersion comparableVersion;
    @Nullable
    private transient Boolean isSnapshot;

    public static Artifact from(String descriptor) {
        String ext = null;
        String classifier = null;
        String[] pts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)descriptor), String.class);
        String group = pts[0];
        String name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        String version = pts[2];
        if (pts.length > 3) {
            classifier = pts[3];
        }
        return new Artifact(group, name, version, classifier, ext);
    }

    public static Artifact from(ArtifactIdentifier identifier) {
        return new Artifact(identifier.getGroup(), identifier.getName(), identifier.getVersion(), identifier.getClassifier(), identifier.getExtension());
    }

    public static Artifact from(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        return new Artifact(group, name, version, classifier, ext);
    }

    Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.classifier = classifier;
        this.ext = ext != null ? ext : "jar";
    }

    public String getLocalPath() {
        return this.getPath().replace('/', File.separatorChar);
    }

    public String getDescriptor() {
        if (this.fullDescriptor == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.group).append(':').append(this.name).append(':').append(this.version);
            if (this.classifier != null) {
                buf.append(':').append(this.classifier);
            }
            if (this.ext != null && !"jar".equals(this.ext)) {
                buf.append('@').append(this.ext);
            }
            this.fullDescriptor = buf.toString();
        }
        return this.fullDescriptor;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = String.join((CharSequence)"/", this.group.replace('.', '/'), this.name, this.version, this.getFilename());
        }
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        if (this.file == null) {
            String file = this.name + '-' + this.version;
            if (this.classifier != null) {
                file = file + '-' + this.classifier;
            }
            this.file = file = file + '.' + this.ext;
        }
        return this.file;
    }

    public boolean isSnapshot() {
        if (this.isSnapshot == null) {
            this.isSnapshot = this.version.toLowerCase(Locale.ROOT).endsWith("-snapshot");
        }
        return this.isSnapshot;
    }

    public Artifact withVersion(String version) {
        return Artifact.from(this.group, this.name, version, this.classifier, this.ext);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Artifact && this.getDescriptor().equals(((Artifact)o).getDescriptor());
    }

    public Spec<Dependency> asDependencySpec() {
        return dep -> this.group.equals(dep.getGroup()) && this.name.equals(dep.getName()) && this.version.equals(dep.getVersion());
    }

    public Predicate<ResolvedArtifact> asArtifactMatcher() {
        return art -> {
            String theirClassifier = art.getClassifier() == null ? "" : art.getClassifier();
            String theirExt = art.getExtension().isEmpty() ? "jar" : art.getExtension();
            return !(this.classifier != null && !this.classifier.equals(theirClassifier) || this.ext != null && !this.ext.equals(theirExt));
        };
    }

    ComparableVersion getComparableVersion() {
        if (this.comparableVersion == null) {
            this.comparableVersion = new ComparableVersion(this.version);
        }
        return this.comparableVersion;
    }

    @Override
    public int compareTo(Artifact o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.group), (Comparable)((Object)o.group)).compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare((Comparable)this.getComparableVersion(), (Comparable)o.getComparableVersion()).compare((Object)this.classifier, (Object)o.classifier, Comparator.nullsFirst(Comparator.naturalOrder())).compare((Object)this.ext, (Object)o.ext, Comparator.nullsFirst(Comparator.naturalOrder())).result();
    }
}

