/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class DownloadMavenArtifact
extends DefaultTask {
    private final Property<Artifact> artifact;
    private boolean changing = false;

    public DownloadMavenArtifact() {
        this.getOutputs().upToDateWhen(task -> false);
        this.artifact = this.getProject().getObjects().property(Artifact.class);
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).zip(this.getArtifact(), (d, a) -> d.file("output." + a.getExtension())));
    }

    @Internal
    public String getResolvedVersion() {
        return MavenArtifactDownloader.getVersion(this.getProject(), ((Artifact)this.getArtifact().get()).getDescriptor());
    }

    @Input
    public Property<Artifact> getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String value) {
        this.getArtifact().set((Object)Artifact.from(value));
    }

    @Input
    public boolean getChanging() {
        return this.changing;
    }

    public void setChanging(boolean value) {
        this.changing = value;
    }

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public void run() throws IOException {
        File out = MavenArtifactDownloader.download(this.getProject(), ((Artifact)this.getArtifact().get()).getDescriptor(), this.getChanging());
        this.setDidWork(out != null && out.exists());
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        if (FileUtils.contentEquals((File)out, (File)output)) {
            return;
        }
        if (output.exists()) {
            output.delete();
        }
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)out, (File)output);
    }
}

