/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class DownloadAssets
extends DefaultTask {
    public DownloadAssets() {
        this.getAssetRepository().convention((Object)"https://resources.download.minecraft.net/");
        this.getConcurrentDownloads().convention((Object)8);
    }

    @TaskAction
    public void run() throws IOException, InterruptedException {
        AssetIndex index = Utils.loadJson(this.getIndex(), AssetIndex.class);
        ArrayList<String> keys = new ArrayList<String>(index.objects.keySet());
        Collections.sort(keys);
        DownloadAssets.removeDuplicateRemotePaths(keys, index);
        File assetsPath = new File(Utils.getMCDir(), "/assets/objects");
        ExecutorService executorService = Executors.newFixedThreadPool((Integer)this.getConcurrentDownloads().get());
        CopyOnWriteArrayList failedDownloads = new CopyOnWriteArrayList();
        String assetRepo = (String)this.getAssetRepository().get();
        for (String key : keys) {
            Asset asset = index.objects.get(key);
            File target = Utils.getCache(this.getProject(), "assets", "objects", asset.getPath());
            if (target.exists() && HashFunction.SHA1.hash(target).equals(asset.hash)) continue;
            URL url = new URL(assetRepo + asset.getPath());
            Runnable copyURLtoFile = () -> {
                try {
                    File localFile = FileUtils.getFile((String[])new String[]{assetsPath + File.separator + asset.getPath()});
                    if (localFile.exists()) {
                        this.getProject().getLogger().lifecycle("Copying local object: " + asset.getPath() + " Asset: " + key);
                        FileUtils.copyFile((File)localFile, (File)target);
                    } else {
                        this.getProject().getLogger().lifecycle("Downloading: " + url + " Asset: " + key);
                        FileUtils.copyURLToFile((URL)url, (File)target, (int)10000, (int)5000);
                    }
                    if (!HashFunction.SHA1.hash(target).equals(asset.hash)) {
                        failedDownloads.add(key);
                        Utils.delete(target);
                        this.getProject().getLogger().error("{} Hash failed.", (Object)key);
                    }
                }
                catch (IOException e) {
                    failedDownloads.add(key);
                    this.getProject().getLogger().error("{} Failed.", (Object)key);
                    e.printStackTrace();
                }
            };
            executorService.execute(copyURLtoFile);
        }
        executorService.shutdown();
        executorService.awaitTermination(8L, TimeUnit.HOURS);
        if (!failedDownloads.isEmpty()) {
            String errorMessage = "";
            for (String key : failedDownloads) {
                errorMessage = errorMessage + "Failed to get asset: " + key + "\n";
            }
            errorMessage = errorMessage + "Some assets failed to download or validate, try running the task again.";
            throw new RuntimeException(errorMessage);
        }
    }

    private static void removeDuplicateRemotePaths(List<String> keys, AssetIndex index) {
        HashSet seen = new HashSet(keys.size());
        keys.removeIf(key -> !seen.add(index.objects.get(key).getPath()));
    }

    private File getIndex() throws IOException {
        VersionJson json = Utils.loadJson(((RegularFile)this.getMeta().get()).getAsFile(), VersionJson.class);
        File target = Utils.getCache(this.getProject(), "assets", "indexes", json.assetIndex.id + ".json");
        return Utils.updateDownload(this.getProject(), target, json.assetIndex);
    }

    @InputFile
    public abstract RegularFileProperty getMeta();

    @Internal
    public abstract Property<String> getAssetRepository();

    @Internal
    public abstract Property<Integer> getConcurrentDownloads();

    @OutputDirectory
    public File getOutput() {
        return Utils.getCache(this.getProject(), "assets");
    }

    private static class Asset {
        String hash;

        private Asset() {
        }

        public String getPath() {
            return this.hash.substring(0, 2) + '/' + this.hash;
        }
    }

    private static class AssetIndex {
        Map<String, Asset> objects;

        private AssetIndex() {
        }
    }
}

