/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ArchiveChecksum
extends DefaultTask {
    public ArchiveChecksum() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(s -> s.file("output.sha256")));
    }

    @TaskAction
    public void run() throws IOException {
        TreeMap checksums = Maps.newTreeMap();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(((RegularFile)this.getInput().get()).getAsFile()));){
            ZipEntry entry;
            byte[] buff = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                HashingInputStream hash2 = new HashingInputStream(Hashing.sha256(), (InputStream)zin);
                while (hash2.read(buff, 0, buff.length) != -1) {
                }
                checksums.put(entry.getName(), Base64.getEncoder().encodeToString(hash2.hash().asBytes()));
            }
        }
        var3_3 = null;
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(((RegularFile)this.getOutput().get()).getAsFile())));){
            checksums.forEach((name, hash) -> {
                out.write((String)hash);
                out.write(32);
                out.write((String)name);
                out.write(10);
            });
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

