/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.userdev.UserDevPlugin;
import net.minecraftforge.gradle.userdev.dependency.DefaultDependencyFilter;
import net.minecraftforge.gradle.userdev.dependency.DefaultDependencyVersionInformationHandler;
import net.minecraftforge.gradle.userdev.dependency.DependencyFilter;
import net.minecraftforge.gradle.userdev.dependency.DependencyVersionInformationHandler;
import net.minecraftforge.gradle.userdev.jarjar.JarJarProjectExtension;
import net.minecraftforge.gradle.userdev.manifest.DefaultInheritManifest;
import net.minecraftforge.gradle.userdev.manifest.InheritManifest;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingVersionUtils;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.Nullable;

public abstract class JarJar
extends Jar {
    private final List<Configuration> configurations;
    private transient DependencyFilter dependencyFilter;
    private transient DependencyVersionInformationHandler dependencyVersionInformationHandler;
    private FileCollection sourceSetsClassesDirs;
    private final ConfigurableFileCollection includedDependencies = this.getProject().files(new Object[]{() -> this.getProject().files(this.getResolvedDependencies().stream().flatMap(d -> d.getAllModuleArtifacts().stream()).map(ResolvedArtifact::getFile).toArray())});
    private final ConfigurableFileCollection metadata = this.getProject().files(new Object[]{() -> {
        this.writeMetadata();
        return this.getProject().files(new Object[]{this.getJarJarMetadataPath().toFile()});
    }});
    private final CopySpec jarJarCopySpec;

    public JarJar() {
        this.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        this.dependencyFilter = new DefaultDependencyFilter(this.getProject());
        this.dependencyVersionInformationHandler = new DefaultDependencyVersionInformationHandler(this.getProject());
        this.setManifest(new DefaultInheritManifest((FileResolver)this.getServices().get(FileResolver.class)));
        this.configurations = new ArrayList<Configuration>();
        this.jarJarCopySpec = this.getMainSpec().addChild();
        this.jarJarCopySpec.into((Object)"META-INF/jarjar");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    FileCollection getSourceSetsClassesDirs() {
        if (this.sourceSetsClassesDirs == null) {
            ConfigurableFileCollection allClassesDirs = this.getProject().getObjects().fileCollection();
            this.sourceSetsClassesDirs = allClassesDirs.filter(File::isDirectory);
        }
        return this.sourceSetsClassesDirs;
    }

    public InheritManifest getManifest() {
        return (InheritManifest)super.getManifest();
    }

    @TaskAction
    protected void copy() {
        this.jarJarCopySpec.from(new Object[]{this.getIncludedDependencies()});
        this.jarJarCopySpec.from(new Object[]{this.getMetadata()});
        super.copy();
    }

    @Classpath
    public FileCollection getIncludedDependencies() {
        return this.includedDependencies;
    }

    @Internal
    public Set<ResolvedDependency> getResolvedDependencies() {
        return this.configurations.stream().flatMap(config -> config.getAllDependencies().stream()).filter(ModuleDependency.class::isInstance).map(ModuleDependency.class::cast).map(this::getResolvedDependency).filter(this.dependencyFilter::isIncluded).collect(Collectors.toSet());
    }

    @Classpath
    public FileCollection getMetadata() {
        return this.metadata;
    }

    public JarJar dependencies(Action<DependencyFilter> c) {
        c.execute((Object)this.dependencyFilter);
        return this;
    }

    public JarJar versionInformation(Action<DependencyVersionInformationHandler> c) {
        c.execute((Object)this.dependencyVersionInformationHandler);
        return this;
    }

    @Classpath
    @Optional
    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Configuration> configurations) {
        this.configurations.clear();
        this.configurations.addAll(configurations);
    }

    @Internal
    public DependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(DependencyFilter filter) {
        this.dependencyFilter = filter;
    }

    public void configuration(@Nullable Configuration configuration) {
        if (configuration == null) {
            return;
        }
        this.configurations.add(configuration);
    }

    public void fromRuntimeConfiguration() {
        Configuration runtimeConfiguration = (Configuration)this.getProject().getConfigurations().findByName("runtimeClasspath");
        if (runtimeConfiguration != null) {
            this.configuration(runtimeConfiguration);
        }
    }

    private void writeMetadata() {
        Path metadataPath = this.getJarJarMetadataPath();
        try {
            metadataPath.toFile().getParentFile().mkdirs();
            Files.deleteIfExists(metadataPath);
            Files.write(metadataPath, (Iterable<? extends CharSequence>)MetadataIOHandler.toLines((Metadata)this.createMetadata()), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JarJar dependency metadata to disk.", e);
        }
    }

    private Path getJarJarMetadataPath() {
        return ((File)this.getProject().getLayout().getBuildDirectory().getAsFile().get()).toPath().resolve("jarjar").resolve(this.getName()).resolve("metadata.json");
    }

    private Metadata createMetadata() {
        return new Metadata(this.configurations.stream().flatMap(config -> config.getAllDependencies().stream()).filter(ModuleDependency.class::isInstance).map(ModuleDependency.class::cast).map(this::createDependencyMetadata).filter(java.util.Optional::isPresent).map(java.util.Optional::get).collect(Collectors.toList()));
    }

    private java.util.Optional<ContainedJarMetadata> createDependencyMetadata(ModuleDependency dependency) {
        if (!this.dependencyFilter.isIncluded(dependency)) {
            return java.util.Optional.empty();
        }
        if (!this.isValidVersionRange(Objects.requireNonNull(this.getVersionRangeFrom(dependency)))) {
            throw this.createInvalidVersionRangeException(dependency, null);
        }
        ResolvedDependency resolvedDependency = this.getResolvedDependency(dependency);
        if (!this.dependencyFilter.isIncluded(resolvedDependency)) {
            return java.util.Optional.empty();
        }
        try {
            return java.util.Optional.of(new ContainedJarMetadata(new ContainedJarIdentifier(dependency.getGroup(), dependency.getName()), new ContainedVersion(VersionRange.createFromVersionSpec((String)this.getVersionRangeFrom(dependency)), (ArtifactVersion)new DefaultArtifactVersion(DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(resolvedDependency.getModuleVersion()))), "META-INF/jarjar/" + ((ResolvedArtifact)resolvedDependency.getAllModuleArtifacts().iterator().next()).getFile().getName(), this.isObfuscated((Dependency)dependency)));
        }
        catch (InvalidVersionSpecificationException e) {
            throw this.createInvalidVersionRangeException(dependency, e);
        }
    }

    private RuntimeException createInvalidVersionRangeException(ModuleDependency dependency, Throwable cause) {
        return new RuntimeException("The given version specification is invalid: " + this.getVersionRangeFrom(dependency) + ". If you used gradle based range versioning like 2.+, convert this to a maven compatible format: [2.0,3.0).", cause);
    }

    private String getVersionRangeFrom(ModuleDependency dependency) {
        java.util.Optional<String> versionRange = this.dependencyVersionInformationHandler.getVersionRange(dependency).map(DeobfuscatingVersionUtils::adaptDeobfuscatedVersionRange);
        if (versionRange.isPresent()) {
            return versionRange.get();
        }
        java.util.Optional<String> attributeVersion = ((JarJarProjectExtension)((Object)this.getProject().getExtensions().getByType(JarJarProjectExtension.class))).getRange((Dependency)dependency);
        return attributeVersion.map(DeobfuscatingVersionUtils::adaptDeobfuscatedVersionRange).orElseGet(() -> DeobfuscatingVersionUtils.adaptDeobfuscatedVersionRange(Objects.requireNonNull(dependency.getVersion())));
    }

    private String getVersionFrom(ModuleDependency dependency) {
        java.util.Optional<String> version = this.dependencyVersionInformationHandler.getVersion(dependency).map(DeobfuscatingVersionUtils::adaptDeobfuscatedVersion);
        if (version.isPresent()) {
            return version.get();
        }
        java.util.Optional<String> attributeVersion = ((JarJarProjectExtension)((Object)this.getProject().getExtensions().getByType(JarJarProjectExtension.class))).getPin((Dependency)dependency);
        return attributeVersion.map(DeobfuscatingVersionUtils::adaptDeobfuscatedVersion).orElseGet(() -> DeobfuscatingVersionUtils.adaptDeobfuscatedVersion(Objects.requireNonNull(dependency.getVersion())));
    }

    private ResolvedDependency getResolvedDependency(ModuleDependency dependency) {
        Set deps;
        ModuleDependency toResolve = dependency.copy();
        if (toResolve instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalDependency = (ExternalModuleDependency)toResolve;
            externalDependency.version(constraint -> constraint.strictly(this.getVersionFrom(dependency)));
        }
        if ((deps = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{toResolve}).getResolvedConfiguration().getFirstLevelModuleDependencies()).isEmpty()) {
            throw new IllegalArgumentException(String.format("Failed to resolve: %s", toResolve));
        }
        return (ResolvedDependency)deps.iterator().next();
    }

    private boolean isObfuscated(Dependency dependency) {
        if (dependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            return projectDependency.getDependencyProject().getPlugins().hasPlugin(UserDevPlugin.class);
        }
        return Objects.requireNonNull(dependency.getVersion()).contains("_mapped_");
    }

    private boolean isValidVersionRange(String range) {
        try {
            VersionRange data = VersionRange.createFromVersionSpec((String)range);
            return data.hasRestrictions() && data.getRecommendedVersion() == null && !range.contains("+");
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }
}

