/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.ChannelProvider;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.srgutils.IMappingFile;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

class OfficialChannelProvider
implements ChannelProvider {
    OfficialChannelProvider() {
    }

    @Override
    public Set<String> getChannels() {
        return ImmutableSet.of((Object)"official");
    }

    @Override
    @Nullable
    public File getMappingsFile(MCPRepo mcpRepo, Project project, String channel, String version) throws IOException {
        String mcpversion = version;
        int idx = version.lastIndexOf(45);
        if (idx != -1 && MinecraftRepo.MCP_CONFIG_VERSION.matcher(version.substring(idx + 1)).matches()) {
            version = version.substring(0, idx);
        }
        File client = MavenArtifactDownloader.generate(project, "net.minecraft:client:" + version + ":mappings@txt", true);
        File server = MavenArtifactDownloader.generate(project, "net.minecraft:server:" + version + ":mappings@txt", true);
        if (client == null || server == null) {
            throw new IllegalStateException("Could not create " + mcpversion + " official mappings due to missing ProGuard mappings.");
        }
        File tsrg = mcpRepo.findRenames("obf_to_srg", IMappingFile.Format.TSRG, mcpversion, false);
        if (tsrg == null) {
            throw new IllegalStateException("Could not create " + mcpversion + " official mappings due to missing MCP's tsrg");
        }
        File mcp = mcpRepo.getMCP(mcpversion);
        if (mcp == null) {
            return null;
        }
        File mappings = mcpRepo.cacheMC("mapping", mcpversion, "mapping", "zip");
        HashStore cache = mcpRepo.commonHash(mcp).load(mcpRepo.cacheMC("mapping", mcpversion, "mapping", "zip.input")).add("pg_client", client).add("pg_server", server).add("tsrg", tsrg).add("codever", "2");
        if (!cache.isSame() || !mappings.exists()) {
            String sname;
            String cname;
            String name;
            IMappingFile.IClass obf;
            IMappingFile pg_client = IMappingFile.load((File)client);
            IMappingFile pg_server = IMappingFile.load((File)server);
            IMappingFile srg = IMappingFile.load((File)tsrg);
            TreeMap<String, String> cfields = new TreeMap<String, String>();
            TreeMap<String, String> sfields = new TreeMap<String, String>();
            TreeMap<String, String> cmethods = new TreeMap<String, String>();
            TreeMap<String, String> smethods = new TreeMap<String, String>();
            for (IMappingFile.IClass cls : pg_client.getClasses()) {
                obf = srg.getClass(cls.getMapped());
                if (obf == null) continue;
                for (IMappingFile.IField fld : cls.getFields()) {
                    name = obf.remapField(fld.getMapped());
                    if (!name.startsWith("field_") && !name.startsWith("f_")) continue;
                    cfields.put(name, fld.getOriginal());
                }
                for (IMappingFile.IMethod mtd : cls.getMethods()) {
                    name = obf.remapMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                    if (!name.startsWith("func_") && !name.startsWith("m_")) continue;
                    cmethods.put(name, mtd.getOriginal());
                }
            }
            for (IMappingFile.IClass cls : pg_server.getClasses()) {
                obf = srg.getClass(cls.getMapped());
                if (obf == null) continue;
                for (IMappingFile.IField fld : cls.getFields()) {
                    name = obf.remapField(fld.getMapped());
                    if (!name.startsWith("field_") && !name.startsWith("f_")) continue;
                    sfields.put(name, fld.getOriginal());
                }
                for (IMappingFile.IMethod mtd : cls.getMethods()) {
                    name = obf.remapMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                    if (!name.startsWith("func_") && !name.startsWith("m_")) continue;
                    smethods.put(name, mtd.getOriginal());
                }
            }
            String[] header = new String[]{"searge", "name", "side", "desc"};
            ArrayList<String[]> fields = new ArrayList<String[]>();
            ArrayList<String[]> methods = new ArrayList<String[]>();
            fields.add(header);
            methods.add(header);
            for (String name2 : cfields.keySet()) {
                cname = (String)cfields.get(name2);
                if (cname.equals(sname = (String)sfields.get(name2))) {
                    fields.add(new String[]{name2, cname, "2", ""});
                    sfields.remove(name2);
                    continue;
                }
                fields.add(new String[]{name2, cname, "0", ""});
            }
            for (String name2 : cmethods.keySet()) {
                cname = (String)cmethods.get(name2);
                if (cname.equals(sname = (String)smethods.get(name2))) {
                    methods.add(new String[]{name2, cname, "2", ""});
                    smethods.remove(name2);
                    continue;
                }
                methods.add(new String[]{name2, cname, "0", ""});
            }
            sfields.forEach((k, v) -> fields.add(new String[]{k, v, "1", ""}));
            smethods.forEach((k, v) -> methods.add(new String[]{k, v, "1", ""}));
            if (!mappings.getParentFile().exists()) {
                mappings.getParentFile().mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(mappings);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                MCPRepo.writeCsv("fields.csv", fields, out);
                MCPRepo.writeCsv("methods.csv", methods, out);
            }
            cache.save();
            Utils.updateHash(mappings, HashFunction.SHA1);
        }
        return mappings;
    }
}

