/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.runs.EclipseRunGenerator;
import net.minecraftforge.gradle.common.util.runs.GenIDERunsTask;
import net.minecraftforge.gradle.common.util.runs.IntellijRunGenerator;
import net.minecraftforge.gradle.common.util.runs.MinecraftPrepareRunTask;
import net.minecraftforge.gradle.common.util.runs.MinecraftRunTask;
import net.minecraftforge.gradle.common.util.runs.VSCodeRunGenerator;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class RunConfigGenerator {
    public abstract void createRunConfiguration(MinecraftExtension var1, File var2, Project var3, List<String> var4, FileCollection var5, FileCollection var6);

    public static void createIDEGenRunsTasks(MinecraftExtension minecraft, TaskProvider<Task> prepareRuns, List<String> additionalClientArgs) {
        Project project = minecraft.getProject();
        ImmutableMap ideConfigurationGenerators = ImmutableMap.builder().put((Object)"genIntellijRuns", (Object)new GeneratorData(new File(project.getRootProject().getRootDir(), ".idea/runConfigurations"), () -> new IntellijRunGenerator(project.getRootProject()))).put((Object)"genEclipseRuns", (Object)new GeneratorData(project.getProjectDir(), EclipseRunGenerator::new)).put((Object)"genVSCodeRuns", (Object)new GeneratorData(new File(project.getProjectDir(), ".vscode"), VSCodeRunGenerator::new)).build();
        ideConfigurationGenerators.forEach((taskName, configurationGenerator) -> project.getTasks().register(taskName, GenIDERunsTask.class, task -> {
            task.dependsOn(new Object[]{prepareRuns});
            task.getRunConfigurationsFolder().set(configurationGenerator.outputFolder);
            task.getRunConfigGenerator().set(project.provider(configurationGenerator.generatorFactory::get));
            task.getMinecraftExtension().set((Object)minecraft);
            task.getAdditionalClientArgs().set((Iterable)additionalClientArgs);
            task.getMinecraftArtifacts().from(new Object[]{RunConfigGenerator.getMinecraftArtifacts(project)});
            task.getRuntimeClasspathArtifacts().from(new Object[]{RunConfigGenerator.getRuntimeClasspathArtifacts(project)});
        }));
    }

    protected static void elementOption(Document document, Element parent, String name, String value) {
        Element option = document.createElement("option");
        option.setAttribute("name", name);
        option.setAttribute("value", value);
        parent.appendChild(option);
    }

    protected static void elementAttribute(Document document, Element parent, String attributeType, String key, Object value) {
        Element attribute = document.createElement(attributeType + "Attribute");
        attribute.setAttribute("key", key);
        attribute.setAttribute("value", value.toString());
        parent.appendChild(attribute);
    }

    @Nullable
    protected static String replaceRootDirBy(Project project, @Nullable String value, String replacement) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return value.replace(project.getRootDir().toString(), replacement);
    }

    protected static Stream<String> mapModClassesToGradle(Project project, RunConfig runConfig) {
        if (runConfig.getMods().isEmpty()) {
            List<SourceSet> sources = runConfig.getAllSources();
            return Stream.concat(sources.stream().map(source -> source.getOutput().getResourcesDir()), sources.stream().map(source -> source.getOutput().getClassesDirs().getFiles()).flatMap(Collection::stream)).map(File::getAbsolutePath);
        }
        SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        return runConfig.getMods().stream().map(modConfig -> (modConfig.getSources().isEmpty() ? Stream.of(main) : modConfig.getSources().stream()).flatMap(source -> Streams.concat((Stream[])new Stream[]{Stream.of(source.getOutput().getResourcesDir()), source.getOutput().getClassesDirs().getFiles().stream()})).map(File::getAbsolutePath).distinct().map(s -> modConfig.getName() + "%%" + s).collect(Collectors.joining(File.pathSeparator)));
    }

    protected static Map<String, Supplier<String>> configureTokensLazy(Project project, RunConfig runConfig, Stream<String> modClasses, FileCollection minecraftArtifacts, FileCollection runtimeClasspathArtifacts) {
        HashMap<String, Supplier<String>> tokens = new HashMap<String, Supplier<String>>();
        runConfig.getTokens().forEach((k, v) -> tokens.put((String)k, () -> v));
        runConfig.getLazyTokens().forEach((k, v) -> {
            Supplier cfr_ignored_0 = (Supplier)tokens.put((String)k, (Supplier<String>)Suppliers.memoize(((Supplier)v)::get));
        });
        tokens.compute("source_roots", (k, v) -> {
            Stream<String> paths;
            if (v == null) {
                paths = modClasses;
            } else {
                String[] existing = ((String)v.get()).split(File.pathSeparator);
                paths = Stream.concat(Arrays.stream(existing), modClasses);
            }
            return Suppliers.memoize(() -> paths.distinct().collect(Collectors.joining(File.pathSeparator)));
        });
        Supplier<String> runtimeClasspath = tokens.compute("runtime_classpath", RunConfigGenerator.makeClasspathToken(runtimeClasspathArtifacts));
        Supplier<String> minecraftClasspath = tokens.compute("minecraft_classpath", RunConfigGenerator.makeClasspathToken(minecraftArtifacts));
        File classpathFolder = new File((File)project.getLayout().getBuildDirectory().getAsFile().get(), "classpath");
        BinaryOperator classpathFileWriter = (filename, classpath) -> {
            if (!classpathFolder.isDirectory() && !classpathFolder.mkdirs()) {
                throw new IllegalStateException("Could not create directory at " + classpathFolder.getAbsolutePath());
            }
            File outputFile = new File(classpathFolder, runConfig.getUniqueFileName() + "_" + filename + ".txt");
            try (BufferedWriter classpathWriter = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                IOUtils.write((String)String.join((CharSequence)System.lineSeparator(), classpath.split(File.pathSeparator)), (Writer)classpathWriter);
            }
            catch (IOException e) {
                project.getLogger().error("Exception when writing classpath to file {}", (Object)outputFile, (Object)e);
            }
            return outputFile.getAbsolutePath();
        };
        tokens.put("runtime_classpath_file", (Supplier<String>)Suppliers.memoize(() -> (String)classpathFileWriter.apply("runtimeClasspath", runtimeClasspath.get())));
        tokens.put("minecraft_classpath_file", (Supplier<String>)Suppliers.memoize(() -> (String)classpathFileWriter.apply("minecraftClasspath", minecraftClasspath.get())));
        runConfig.getEnvironment().compute("MOD_CLASSES", (key, value) -> Strings.isNullOrEmpty((String)value) || "dummy".equals(value) ? "{source_roots}" : value);
        return tokens;
    }

    private static BiFunction<String, Supplier<String>, Supplier<String>> makeClasspathToken(FileCollection classpath) {
        return (key, supplier) -> Suppliers.memoize(() -> RunConfigGenerator.lambda$null$17(classpath, (Supplier)supplier));
    }

    private static String getResolvedClasspath(Set<File> artifacts) {
        return artifacts.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private static FileCollection getArtifactFiles(Configuration runtimeClasspath) {
        return runtimeClasspath.copyRecursive().getIncoming().getArtifacts().getArtifactFiles();
    }

    protected static FileCollection getMinecraftArtifacts(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration minecraft = (Configuration)configurations.findByName("minecraft");
        if (minecraft == null) {
            minecraft = (Configuration)configurations.findByName("minecraftImplementation");
        }
        if (minecraft == null) {
            throw new IllegalStateException("Could not find valid minecraft configuration!");
        }
        return RunConfigGenerator.getArtifactFiles(minecraft);
    }

    protected static FileCollection getRuntimeClasspathArtifacts(Project project) {
        return RunConfigGenerator.getArtifactFiles(project.getConfigurations().getByName("runtimeClasspath"));
    }

    public static TaskProvider<MinecraftRunTask> createRunTask(RunConfig runConfig, Project project, TaskProvider<Task> prepareRuns, List<String> additionalClientArgs) {
        TaskProvider prepareRun = project.getTasks().register(runConfig.getPrepareTaskName(), MinecraftPrepareRunTask.class, task -> task.dependsOn(new Object[]{prepareRuns}));
        TaskProvider prepareRunCompile = project.getTasks().register(runConfig.getPrepareCompileTaskName(), MinecraftPrepareRunTask.class, task -> task.dependsOn(runConfig.getAllSources().stream().map(SourceSet::getClassesTaskName).toArray()));
        return project.getTasks().register(runConfig.getTaskName(), MinecraftRunTask.class, task -> {
            task.setGroup("ForgeGradle runs");
            task.dependsOn(new Object[]{prepareRun, prepareRunCompile});
            task.dependsOn(runConfig.getAllSources().stream().map(SourceSet::getClassesTaskName).toArray());
            task.getRunConfig().set((Object)runConfig);
            task.getMainClass().set((Object)runConfig.getMain());
            task.getAdditionalClientArgs().set((Iterable)additionalClientArgs);
            task.getMinecraftArtifacts().from(new Object[]{RunConfigGenerator.getMinecraftArtifacts(project)});
            task.getRuntimeClasspathArtifacts().from(new Object[]{RunConfigGenerator.getRuntimeClasspathArtifacts(project)});
        });
    }

    protected static String fixupArg(String replace) {
        if (replace.startsWith("\"")) {
            return replace;
        }
        if (!replace.contains(" ")) {
            return replace;
        }
        return '\"' + replace + '\"';
    }

    protected static String getArgs(RunConfig runConfig, Map<String, ?> updatedTokens) {
        return RunConfigGenerator.getArgsStream(runConfig, updatedTokens, true).collect(Collectors.joining(" "));
    }

    protected static Stream<String> getArgsStream(RunConfig runConfig, Map<String, ?> updatedTokens, boolean wrapSpaces) {
        Stream<String> args = runConfig.getArgs().stream().map(value -> runConfig.replace(updatedTokens, (String)value));
        return wrapSpaces ? args.map(RunConfigGenerator::fixupArg) : args;
    }

    protected static String getJvmArgs(RunConfig runConfig, List<String> additionalClientArgs, Map<String, ?> updatedTokens) {
        return RunConfigGenerator.getJvmArgsStream(runConfig, additionalClientArgs, updatedTokens).collect(Collectors.joining(" "));
    }

    private static Stream<String> getJvmArgsStream(RunConfig runConfig, List<String> additionalClientArgs, Map<String, ?> updatedTokens) {
        Stream<String> propStream = Stream.concat(runConfig.getProperties().entrySet().stream().map(kv -> String.format("-D%s=%s", kv.getKey(), runConfig.replace(updatedTokens, (String)kv.getValue()))), runConfig.getJvmArgs().stream().map(value -> runConfig.replace(updatedTokens, (String)value))).map(RunConfigGenerator::fixupArg);
        if (runConfig.isClient()) {
            return Stream.concat(propStream, additionalClientArgs.stream());
        }
        return propStream;
    }

    private static /* synthetic */ String lambda$null$17(FileCollection classpath, Supplier supplier) {
        String resolvedClasspath = RunConfigGenerator.getResolvedClasspath(classpath.getFiles());
        if (supplier == null) {
            return resolvedClasspath;
        }
        String oldCp = (String)supplier.get();
        if (Strings.isNullOrEmpty((String)oldCp)) {
            return resolvedClasspath;
        }
        if (Strings.isNullOrEmpty((String)resolvedClasspath)) {
            return oldCp;
        }
        return String.join((CharSequence)File.pathSeparator, oldCp, resolvedClasspath);
    }

    protected static class GeneratorData {
        protected final File outputFolder;
        protected final Supplier<RunConfigGenerator> generatorFactory;

        public GeneratorData(File outputFolder, Supplier<RunConfigGenerator> generatorFactory) {
            this.outputFolder = outputFolder;
            this.generatorFactory = generatorFactory;
        }
    }

    static abstract class JsonConfigurationBuilder
    extends RunConfigGenerator {
        JsonConfigurationBuilder() {
        }

        protected abstract JsonObject createRunConfiguration(Project var1, RunConfig var2, List<String> var3, FileCollection var4, FileCollection var5);

        protected abstract JsonObject createPrepareTaskConfiguration(Project var1, RunConfig var2);

        @Override
        public final void createRunConfiguration(MinecraftExtension minecraft, File runConfigurationsDir, Project project, List<String> additionalClientArgs, FileCollection minecraftArtifacts, FileCollection runtimeClasspathArtifacts) {
            JsonObject runObject = new JsonObject();
            runObject.addProperty("version", "0.2.0");
            JsonArray runConfigs = new JsonArray();
            minecraft.getRuns().forEach(runConfig -> {
                MinecraftRunTask.prepareWorkingDirectory(runConfig);
                runConfigs.add((JsonElement)this.createRunConfiguration(project, (RunConfig)runConfig, additionalClientArgs, minecraftArtifacts, runtimeClasspathArtifacts));
            });
            runObject.add("configurations", (JsonElement)runConfigs);
            try (FileWriter writer = new FileWriter(new File(runConfigurationsDir, "launch.json"));){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson((JsonElement)runObject));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsonObject prepareObject = new JsonObject();
            prepareObject.addProperty("version", "2.0.0");
            JsonArray prepareConfigs = new JsonArray();
            minecraft.getRuns().forEach(runConfig -> {
                MinecraftRunTask.prepareWorkingDirectory(runConfig);
                prepareConfigs.add((JsonElement)this.createPrepareTaskConfiguration(project, (RunConfig)runConfig));
            });
            prepareObject.add("tasks", (JsonElement)prepareConfigs);
            try (FileWriter writer = new FileWriter(new File(runConfigurationsDir, "tasks.json"));){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson((JsonElement)prepareObject));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static abstract class XMLConfigurationBuilder
    extends RunConfigGenerator {
        XMLConfigurationBuilder() {
        }

        protected abstract Map<String, Document> createRunConfiguration(MinecraftExtension var1, Project var2, RunConfig var3, DocumentBuilder var4, List<String> var5, FileCollection var6, FileCollection var7);

        @Override
        public final void createRunConfiguration(MinecraftExtension minecraft, File runConfigurationsDir, Project project, List<String> additionalClientArgs, FileCollection minecraftArtifacts, FileCollection runtimeClasspathArtifacts) {
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                minecraft.getRuns().forEach(runConfig -> {
                    MinecraftRunTask.prepareWorkingDirectory(runConfig);
                    Map<String, Document> documents = this.createRunConfiguration(minecraft, project, (RunConfig)runConfig, docBuilder, additionalClientArgs, minecraftArtifacts, runtimeClasspathArtifacts);
                    documents.forEach((fileName, document) -> {
                        DOMSource source = new DOMSource((Node)document);
                        File location = new File(runConfigurationsDir, (String)fileName);
                        if (!location.getParentFile().exists()) {
                            location.getParentFile().mkdirs();
                        }
                        StreamResult result = new StreamResult(location);
                        try {
                            transformer.transform(source, result);
                        }
                        catch (TransformerException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

