/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.artifactural.gradle.GradleRepositoryAdapter;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.legacy.LegacyExtension;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.tasks.ide.CopyEclipseResources;
import net.minecraftforge.gradle.common.tasks.ide.CopyIntellijResources;
import net.minecraftforge.gradle.common.util.EclipseHacks;
import net.minecraftforge.gradle.common.util.EnvironmentChecks;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(MCPConfigV1.Step.class, (Object)new MCPConfigV1.Step.Deserializer()).registerTypeAdapter(VersionJson.Argument.class, (Object)new VersionJson.Argument.Deserializer()).setPrettyPrinting().create();
    static final int CACHE_TIMEOUT = 3600000;
    public static final String FORGE_MAVEN = "https://maven.minecraftforge.net/";
    public static final String MOJANG_MAVEN = "https://libraries.minecraft.net/";
    public static final String SPECIALSOURCE = "net.md-5:SpecialSource:1.11.2:shaded";
    public static final String BINPATCHER = Utils.art("binarypatcher", "1.2.0", "fatjar");
    public static final String ACCESSTRANSFORMER = Utils.art("accesstransformers", "8.2.1", "fatjar");
    public static final String FART = Utils.art("ForgeAutoRenamingTool", "1.0.6", "all");
    public static final String SRG2SOURCE = Utils.art("Srg2Source", "8.0.9", "fatjar");
    public static final String SIDESTRIPPER = Utils.art("mergetool", "1.1.7", "fatjar");
    public static final String INSTALLERTOOLS = Utils.art("installertools", "1.4.4", "fatjar");
    public static final String JARCOMPATIBILITYCHECKER = Utils.art("JarCompatibilityChecker", "0.1.28", "all");
    public static final long ZIPTIME = 628041600000L;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static final Action<? super MavenArtifactRepository> forgeMaven() {
        return e -> {
            e.setUrl((Object)FORGE_MAVEN);
            e.metadataSources(m -> {
                m.gradleMetadata();
                m.mavenPom();
                m.artifact();
            });
        };
    }

    public static final Action<? super MavenArtifactRepository> mojangMaven() {
        return e -> {
            e.setUrl((Object)MOJANG_MAVEN);
            e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
            Utils.filterForge().execute(e);
        };
    }

    public static final Action<? super MavenArtifactRepository> filterForge() {
        return e -> e.mavenContent(c -> c.excludeGroup("net.minecraftforge"));
    }

    private static final String art(String name, String ver, String classifier) {
        return "net.minecraftforge:" + name + ':' + ver + ':' + classifier;
    }

    public static void extractFile(ZipFile zip, String name, File output) throws IOException {
        Utils.extractFile(zip, zip.getEntry(name), output);
    }

    public static void extractFile(ZipFile zip, ZipEntry entry, File output) throws IOException {
        File parent = output.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (InputStream stream = zip.getInputStream(entry);){
            Files.copy(stream, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void extractDirectory(Function<String, File> fileLocator, ZipFile zip, String directory) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (e.isDirectory() || !e.getName().startsWith(directory)) continue;
            Utils.extractFile(zip, e, fileLocator.apply(e.getName()));
        }
    }

    public static Set<String> copyZipEntries(ZipOutputStream zout, ZipInputStream zin, Predicate<String> filter) throws IOException {
        ZipEntry entry;
        HashSet<String> added = new HashSet<String>();
        while ((entry = zin.getNextEntry()) != null) {
            if (!filter.test(entry.getName())) continue;
            ZipEntry _new = new ZipEntry(entry.getName());
            _new.setTime(0L);
            zout.putNextEntry(_new);
            IOUtils.copy((InputStream)zin, (OutputStream)zout);
            added.add(entry.getName());
        }
        return added;
    }

    public static byte[] base64DecodeStringList(List<String> strings) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String string : strings) {
            bos.write(Base64.getDecoder().decode(string));
        }
        return bos.toByteArray();
    }

    public static File delete(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    public static File createEmpty(File file) throws IOException {
        Utils.delete(file);
        file.createNewFile();
        return file;
    }

    public static Path getCacheBase(Project project) {
        File gradleUserHomeDir = project.getGradle().getGradleUserHomeDir();
        return Paths.get(gradleUserHomeDir.getPath(), "caches", "forge_gradle");
    }

    public static File getCache(Project project, String ... tail) {
        return Paths.get(Utils.getCacheBase(project).toString(), tail).toFile();
    }

    public static void extractZip(File source, File target, boolean overwrite) throws IOException {
        Utils.extractZip(source, target, overwrite, false);
    }

    public static void extractZip(File source, File target, boolean overwrite, boolean deleteExtras) throws IOException {
        Utils.extractZip(source, target, overwrite, deleteExtras, name -> name);
    }

    public static void extractZip(File source, File target, boolean overwrite, boolean deleteExtras, Function<String, String> renamer) throws IOException {
        HashSet extra = deleteExtras ? Files.walk(target.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toSet()) : new HashSet();
        try (ZipFile zip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                Throwable throwable;
                String name;
                ZipEntry e = enu.nextElement();
                if (e.isDirectory() || (name = renamer.apply(e.getName())) == null) continue;
                File out = new File(target, name);
                File parent = out.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                extra.remove(out);
                if (out.exists()) {
                    if (!overwrite) continue;
                    FileInputStream fis = new FileInputStream(out);
                    throwable = null;
                    try {
                        if (IOUtils.contentEquals((InputStream)zip.getInputStream(e), (InputStream)fis)) {
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                        continue;
                    }
                }
                FileOutputStream fos = new FileOutputStream(out);
                throwable = null;
                try {
                    IOUtils.copy((InputStream)zip.getInputStream(e), (OutputStream)fos);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
        if (deleteExtras) {
            extra.forEach(File::delete);
            Files.walk(target.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.reverseOrder()).map(Path::toFile).filter(f -> f.list().length == 0).forEach(File::delete);
        }
    }

    public static File updateDownload(Project project, File target, VersionJson.Download dl) throws IOException {
        if (!target.exists() || !HashFunction.SHA1.hash(target).equals(dl.sha1)) {
            project.getLogger().lifecycle("Downloading: " + dl.url);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            FileUtils.copyURLToFile((URL)dl.url, (File)target);
        }
        return target;
    }

    public static <T> T loadJson(File target, Class<T> clz) throws IOException {
        try (FileInputStream in = new FileInputStream(target);){
            Object object = GSON.fromJson((Reader)new InputStreamReader(in), clz);
            return (T)object;
        }
    }

    public static <T> T loadJson(InputStream in, Class<T> clz) {
        return (T)GSON.fromJson((Reader)new InputStreamReader(in), clz);
    }

    public static void updateHash(File target) throws IOException {
        Utils.updateHash(target, HashFunction.values());
    }

    public static void updateHash(File target, HashFunction ... functions) throws IOException {
        for (HashFunction function : functions) {
            File cache = new File(target.getAbsolutePath() + "." + function.getExtension());
            if (target.exists()) {
                String hash = function.hash(target);
                Files.write(cache.toPath(), hash.getBytes(), new OpenOption[0]);
                continue;
            }
            if (!cache.exists()) continue;
            cache.delete();
        }
    }

    public static void forZip(ZipFile zip, IOConsumer<ZipEntry> consumer) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            consumer.accept(entries.nextElement());
        }
    }

    @Nullable
    public static String resolveString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Closure) {
            return Utils.resolveString(((Closure)obj).call());
        }
        if (obj instanceof Callable) {
            try {
                return Utils.resolveString(((Callable)obj).call());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (obj instanceof File) {
            return ((File)obj).getAbsolutePath();
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.toString((Object[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            return obj.getClass().getSimpleName();
        }
        return obj.toString();
    }

    public static <T> T[] toArray(JsonArray array, Function<JsonElement, T> adapter, IntFunction<T[]> arrayFactory) {
        return StreamSupport.stream(array.spliterator(), false).map(adapter).toArray(arrayFactory);
    }

    public static byte[] getZipData(File file, String name) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry(name);
            if (entry == null) {
                throw new IOException("Zip Missing Entry: " + name + " File: " + file);
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            return byArray;
        }
    }

    public static <T> T fromJson(InputStream stream, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    public static <T> T fromJson(byte[] data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), classOfT);
    }

    public static String capitalize(String toCapitalize) {
        return toCapitalize.length() > 1 ? toCapitalize.substring(0, 1).toUpperCase() + toCapitalize.substring(1) : toCapitalize;
    }

    public static Stream<String> lines(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        return (Stream)reader.lines().onClose(() -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static ZipEntry getStableEntry(String name) {
        return Utils.getStableEntry(name, 628041600000L);
    }

    public static ZipEntry getStableEntry(String name, long time) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(time);
        TimeZone.setDefault(_default);
        return ret;
    }

    public static void createRunConfigTasks(MinecraftExtension extension, TaskProvider<ExtractNatives> extractNatives, TaskProvider<?> ... setupTasks) {
        TaskProvider makeSrcDirs = extension.getProject().getTasks().register("makeSrcDirs", Task.class, task -> task.doFirst(t -> {
            JavaPluginExtension java = (JavaPluginExtension)task.getProject().getExtensions().getByType(JavaPluginExtension.class);
            java.getSourceSets().forEach(s -> s.getAllSource().getSrcDirs().stream().filter(f -> !f.exists()).forEach(File::mkdirs));
        }));
        TaskProvider prepareRuns = extension.getProject().getTasks().register("prepareRuns", Task.class, task -> {
            task.setGroup("ForgeGradle prepare runs");
            task.dependsOn(new Object[]{extractNatives, setupTasks, makeSrcDirs});
        });
        extension.getRuns().forEach(RunConfig::mergeParents);
        extension.getProject().getGradle().projectsEvaluated(gradle -> {
            VersionJson json = null;
            try {
                json = Utils.loadJson(((RegularFile)((ExtractNatives)((Object)((Object)extractNatives.get()))).getMeta().get()).getAsFile(), VersionJson.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            List<String> additionalClientArgs = json != null ? json.getPlatformJvmArgs() : Collections.emptyList();
            extension.getRuns().forEach(RunConfig::mergeChildren);
            extension.getRuns().forEach(run -> RunConfigGenerator.createRunTask(run, extension.getProject(), (TaskProvider<Task>)prepareRuns, additionalClientArgs));
            EclipseHacks.doEclipseFixes(extension, extractNatives, prepareRuns);
            LegacyExtension.runRetrogradleFixes(extension.getProject());
            RunConfigGenerator.createIDEGenRunsTasks(extension, (TaskProvider<Task>)prepareRuns, additionalClientArgs);
        });
    }

    public static void addRepoFilters(Project project) {
        if (!EnvironmentChecks.FILTER_REPOS.isEnabled()) {
            return;
        }
        if (project.getGradle().getStartParameter().getTaskNames().stream().anyMatch(t -> t.endsWith("DownloadSources"))) {
            project.getRepositories().forEach(Utils::addMappedFilter);
        } else {
            project.getRepositories().all(Utils::addMappedFilter);
        }
    }

    private static void addMappedFilter(ArtifactRepository repository) {
        if (repository instanceof GradleRepositoryAdapter) {
            return;
        }
        repository.content(rcd -> rcd.excludeVersionByRegex(".*", ".*", ".*_mapped_.*"));
    }

    public static File getMCDir() {
        switch (VersionJson.OS.getCurrent()) {
            case OSX: {
                return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft");
            }
            case WINDOWS: {
                return new File(System.getenv("APPDATA") + "\\.minecraft");
            }
        }
        return new File(System.getProperty("user.home") + "/.minecraft");
    }

    public static String replaceTokens(Map<String, ?> tokens, String value) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '\\') {
                if (x == value.length() - 1) {
                    throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                }
                buf.append(value.charAt(++x));
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder key = new StringBuilder();
                for (int y = x + 1; y <= value.length(); ++y) {
                    if (y == value.length()) {
                        throw new IllegalArgumentException("Illegal pattern (Unclosed " + c + "): " + value);
                    }
                    char d = value.charAt(y);
                    if (d == '\\') {
                        if (y == value.length() - 1) {
                            throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                        }
                        key.append(value.charAt(++y));
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        x = y;
                        break;
                    }
                    if (c == '\'' && d == '\'') {
                        x = y;
                        break;
                    }
                    key.append(d);
                }
                if (c == '\'') {
                    buf.append((CharSequence)key);
                    continue;
                }
                Object v = tokens.get(key.toString());
                if (v instanceof Supplier) {
                    v = ((Supplier)v).get();
                }
                buf.append((Object)(v == null ? "{" + key + "}" : v));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static int getMappingSeparatorIdx(String mapping) {
        if (!mapping.contains("23w13a_or_b")) {
            return mapping.lastIndexOf(95);
        }
        return mapping.indexOf(95);
    }

    public static void setupIDEResourceCopy(Project project) {
        boolean ideaFound = true;
        if (project.getPlugins().hasPlugin(IdeaPlugin.class)) {
            IdeaPlugin idea = (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
            project.getTasks().register("copyIntellijResources", CopyIntellijResources.class, task -> task.configure(idea.getModel(), project));
        } else {
            ideaFound = false;
        }
        if (project.getPlugins().hasPlugin(EclipsePlugin.class)) {
            TaskProvider taskProvider = project.getTasks().register("copyEclipseResources", CopyEclipseResources.class, task -> task.dependsOn(new Object[]{"eclipse"}));
            project.getTasks().named("eclipse").configure(eclipseTask -> eclipseTask.doLast(eclTask -> {
                EclipseModel eclipse = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
                ((CopyEclipseResources)((Object)((Object)((Object)taskProvider.get())))).configure(Objects.requireNonNull(eclipse), project);
            }));
        } else if (!ideaFound) {
            project.getLogger().warn("Neither the 'eclipse' nor the 'idea' plugins were found, but IDE resource copy has been enabled.");
        }
    }

    public static String getIntellijOutName(SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "production" : sourceSet.getName();
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

