/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;

public abstract class MinecraftExtension
extends GroovyObjectSupport {
    protected final Project project;
    protected final NamedDomainObjectContainer<RunConfig> runs;
    protected final ConfigurableFileCollection accessTransformers;
    private final Provider<String> mapping;

    @Inject
    public MinecraftExtension(Project project) {
        this.project = project;
        this.mapping = this.getMappingChannel().zip(this.getMappingVersion(), (ch, ver) -> ch + '_' + ver);
        this.runs = project.getObjects().domainObjectContainer(RunConfig.class, name -> new RunConfig(project, name));
        this.accessTransformers = project.getObjects().fileCollection();
        this.getCopyIdeResources().convention((Object)false);
        this.getEnableIdeaPrepareRuns().convention((Object)false);
        this.getEnableEclipsePrepareRuns().convention((Object)false);
        this.getGenerateRunFolders().convention((Object)false);
    }

    public Project getProject() {
        return this.project;
    }

    public NamedDomainObjectContainer<RunConfig> runs(Closure closure) {
        return this.runs.configure(closure);
    }

    public NamedDomainObjectContainer<RunConfig> getRuns() {
        return this.runs;
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name);
        }
        Closure closure = (Closure)value;
        RunConfig runConfig = (RunConfig)this.getRuns().maybeCreate(name);
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)runConfig);
        closure.call();
    }

    public abstract Property<String> getMappingChannel();

    public abstract Property<String> getMappingVersion();

    public Provider<String> getMappings() {
        return this.mapping;
    }

    public void mappings(Provider<String> channel, Provider<String> version) {
        this.getMappingChannel().set(channel);
        this.getMappingVersion().set(version);
    }

    public void mappings(String channel, String version) {
        this.getMappingChannel().set((Object)channel);
        this.getMappingVersion().set((Object)version);
    }

    public void mappings(Object channel, Object version) {
        this.setMappingProperty(this.getMappingChannel(), channel);
        this.setMappingProperty(this.getMappingVersion(), version);
    }

    public void mappings(Map<String, ?> mappings) {
        Object channel = mappings.get("channel");
        Object version = mappings.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify both mappings channel and version");
        }
        this.mappings(channel, version);
    }

    private void setMappingProperty(Property<String> property, Object value) {
        Provider provider = value instanceof ProviderConvertible ? ((ProviderConvertible)value).asProvider() : (value instanceof Provider ? (Provider)value : this.project.provider(() -> value));
        property.set(provider.map(Object::toString));
    }

    public ConfigurableFileCollection getAccessTransformers() {
        return this.accessTransformers;
    }

    public void setAccessTransformers(Object ... files) {
        this.getAccessTransformers().setFrom(files);
    }

    public void setAccessTransformer(Object files) {
        this.getAccessTransformers().setFrom(new Object[]{files});
    }

    public void accessTransformers(Object ... files) {
        this.getAccessTransformers().from(files);
    }

    public void accessTransformer(Object file) {
        this.getAccessTransformers().from(new Object[]{file});
    }

    public abstract ConfigurableFileCollection getSideAnnotationStrippers();

    public abstract Property<Boolean> getEnableEclipsePrepareRuns();

    public abstract Property<Boolean> getEnableIdeaPrepareRuns();

    public abstract Property<Boolean> getCopyIdeResources();

    public abstract Property<Boolean> getGenerateRunFolders();

    public Action<? super MavenArtifactRepository> getForgeMaven() {
        return Utils.forgeMaven();
    }

    public Action<? super MavenArtifactRepository> getMojangMaven() {
        return Utils.mojangMaven();
    }
}

