/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class DownloadUtils {
    private static final Map<String, DecompressionStrategy> DECOMPRESSION_STRATEGIES = ImmutableMap.of((Object)"identity", stream -> stream, (Object)"gzip", GZIPInputStream::new, (Object)"deflate", InflaterInputStream::new);
    private static final String ACCEPT_ENCODING = String.join((CharSequence)", ", DECOMPRESSION_STRATEGIES.keySet());

    private DownloadUtils() {
    }

    public static boolean downloadEtag(URL url, File output, boolean offline) throws IOException {
        String initialEtagValue;
        HttpURLConnection con;
        if (output.exists() && output.lastModified() > System.currentTimeMillis() - 3600000L) {
            return true;
        }
        if (output.exists() && offline) {
            return true;
        }
        File efile = new File(output.getAbsolutePath() + ".etag");
        String etag = "";
        if (efile.exists()) {
            etag = new String(Files.readAllBytes(efile.toPath()), StandardCharsets.UTF_8);
        }
        if ((con = DownloadUtils.connectHttpWithRedirects(url, arg_0 -> DownloadUtils.lambda$downloadEtag$1(output, initialEtagValue = etag, arg_0))).getResponseCode() == 304) {
            output.setLastModified(new Date().getTime());
            return true;
        }
        if (con.getResponseCode() == 200) {
            try {
                DownloadUtils.downloadFileConsideringCompression(con, output);
                etag = con.getHeaderField("ETag");
                if (etag == null || etag.isEmpty()) {
                    Files.write(efile.toPath(), new byte[0], new OpenOption[0]);
                } else {
                    Files.write(efile.toPath(), etag.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                return true;
            }
            catch (IOException e) {
                output.delete();
                throw e;
            }
        }
        return false;
    }

    public static boolean downloadFile(URL url, File output, boolean deleteOn404) {
        return DownloadUtils.downloadFile(url, output, null, deleteOn404);
    }

    public static boolean downloadFile(URL url, File output, @Nullable Map<String, String> headers, boolean deleteOn404) {
        block7: {
            String proto = url.getProtocol().toLowerCase();
            try {
                if ("http".equals(proto) || "https".equals(proto)) {
                    HttpURLConnection con = DownloadUtils.connectHttpWithRedirects(url, urlCon -> {
                        if (headers != null) {
                            for (Map.Entry entry : headers.entrySet()) {
                                urlCon.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                    });
                    int responseCode = con.getResponseCode();
                    if (responseCode == 200) {
                        return DownloadUtils.downloadFile(con, output);
                    }
                    if (responseCode == 404 && deleteOn404 && output.exists()) {
                        output.delete();
                    }
                    break block7;
                }
                URLConnection con = url.openConnection();
                con.connect();
                return DownloadUtils.downloadFile(con, output);
            }
            catch (FileNotFoundException e) {
                if (deleteOn404 && output.exists()) {
                    output.delete();
                }
            }
            catch (IOException e) {
                if (!output.exists()) break block7;
                output.delete();
            }
        }
        return false;
    }

    private static boolean downloadFile(URLConnection con, File output) throws IOException {
        try {
            DownloadUtils.downloadFileConsideringCompression(con, output);
            return true;
        }
        catch (IOException e) {
            if (output.exists()) {
                output.delete();
            }
            throw e;
        }
    }

    @Nullable
    public static String downloadString(URL url) throws IOException {
        String proto = url.getProtocol().toLowerCase();
        if ("http".equals(proto) || "https".equals(proto)) {
            HttpURLConnection con = DownloadUtils.connectHttpWithRedirects(url);
            if (con.getResponseCode() == 200) {
                return DownloadUtils.downloadString(con);
            }
        } else {
            URLConnection con = url.openConnection();
            con.connect();
            return DownloadUtils.downloadString(con);
        }
        return null;
    }

    private static String downloadString(URLConnection con) throws IOException {
        int len = con.getContentLength();
        InputStream is = DownloadUtils.getInputStream(con);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = IOUtils.copy((InputStream)is, (OutputStream)out);
        if (DownloadUtils.isEncoded(con) && len != -1 && read != len) {
            throw new IOException("Failed to read all data from " + con.getURL() + "; got " + read + " expected " + len);
        }
        Charset charset = StandardCharsets.UTF_8;
        if (con.getContentType() != null) {
            try {
                charset = (Charset)MediaType.parse((String)con.getContentType()).charset().or((Object)StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new String(out.toByteArray(), charset);
    }

    @Nullable
    public static File downloadWithCache(URL url, File target, boolean changing, boolean bypassLocal) throws IOException {
        return DownloadUtils.downloadWithCache(url, target, null, changing, bypassLocal);
    }

    @Nullable
    public static File downloadWithCache(URL url, File target, @Nullable Map<String, String> headers, boolean changing, boolean bypassLocal) throws IOException {
        String expected;
        String actual;
        File md5_file = new File(target.getAbsolutePath() + ".md5");
        String string = actual = target.exists() ? HashFunction.MD5.hash(target) : null;
        if (md5_file.exists() && target.exists() && !changing && !bypassLocal && (expected = new String(Files.readAllBytes(md5_file.toPath()), StandardCharsets.UTF_8)).equals(actual)) {
            return target;
        }
        expected = null;
        try {
            expected = DownloadUtils.downloadString(new URL(url + ".md5"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (expected == null && bypassLocal) {
            return null;
        }
        if (expected != null && expected.equals(actual)) {
            Files.write(md5_file.toPath(), expected.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return target;
        }
        if (target.exists()) {
            target.delete();
        }
        if (!DownloadUtils.downloadFile(url, target, headers, false)) {
            target.delete();
            return null;
        }
        Utils.updateHash(target, HashFunction.MD5);
        return target;
    }

    public static HttpURLConnection connectHttpWithRedirects(URL url) throws IOException {
        return DownloadUtils.connectHttpWithRedirects(url, setupCon -> {});
    }

    public static HttpURLConnection connectHttpWithRedirects(URL url, Consumer<HttpURLConnection> setup) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setInstanceFollowRedirects(true);
        con.addRequestProperty("Accept-Encoding", ACCEPT_ENCODING);
        setup.accept(con);
        con.connect();
        if ("http".equalsIgnoreCase(url.getProtocol())) {
            int responseCode = con.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 302: 
                case 303: {
                    String newLocation = con.getHeaderField("Location");
                    URL newUrl = new URL(newLocation);
                    if (!"https".equalsIgnoreCase(newUrl.getProtocol())) break;
                    return DownloadUtils.connectHttpWithRedirects(newUrl, setup);
                }
            }
        }
        return con;
    }

    private static void downloadFileConsideringCompression(URLConnection connection, File output) throws IOException {
        int len = connection.getContentLength();
        InputStream in = DownloadUtils.getInputStream(connection);
        File parent = output.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(output);){
            int read = IOUtils.copy((InputStream)in, (OutputStream)fos);
            if (DownloadUtils.isEncoded(connection) && len != -1 && read != len) {
                throw new IOException("Failed to read all data from " + connection.getURL() + "; got " + read + " expected " + len);
            }
        }
    }

    private static InputStream getInputStream(URLConnection connection) throws IOException {
        String[] encodings;
        String encoding = connection.getContentEncoding();
        if (encoding == null || encoding.isEmpty()) {
            return connection.getInputStream();
        }
        InputStream is = connection.getInputStream();
        for (String enc : encodings = encoding.split(",")) {
            DecompressionStrategy strategy = DECOMPRESSION_STRATEGIES.get(enc.trim());
            if (strategy == null) {
                throw new IOException("Unknown content-encoding \"" + enc + "\"!");
            }
            is = strategy.wrap(is);
        }
        return is;
    }

    private static boolean isEncoded(URLConnection connection) {
        String enc = connection.getContentEncoding();
        return enc == null || enc.equals("identity");
    }

    private static /* synthetic */ void lambda$downloadEtag$1(File output, String initialEtagValue, HttpURLConnection setupCon) {
        if (output.exists()) {
            setupCon.setIfModifiedSince(output.lastModified());
        }
        if (!initialEtagValue.isEmpty()) {
            setupCon.setRequestProperty("If-None-Match", initialEtagValue);
        }
    }

    @FunctionalInterface
    public static interface DecompressionStrategy {
        public InputStream wrap(InputStream var1) throws IOException;
    }
}

