/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.util.Utils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class UserdevConfigV2
extends UserdevConfigV1 {
    public DataFunction processor;
    public String patchesOriginalPrefix;
    public String patchesModifiedPrefix;
    @Nullable
    private Boolean notchObf;
    @Nullable
    private List<String> universalFilters;
    @Nullable
    public List<String> modules;
    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="V3")
    public ScopedDependencies extraDependencies;
    private String sourceFileCharset = StandardCharsets.UTF_8.name();

    public static UserdevConfigV2 get(InputStream stream) {
        return Utils.fromJson(stream, UserdevConfigV2.class);
    }

    public static UserdevConfigV2 get(byte[] data) {
        return UserdevConfigV2.get(new ByteArrayInputStream(data));
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value ? Boolean.valueOf(true) : null;
    }

    public boolean getNotchObf() {
        return this.notchObf != null && this.notchObf != false;
    }

    public void setSourceFileCharset(String value) {
        if (!Charset.isSupported(value)) {
            throw new IllegalArgumentException("Unsupported charset: " + value);
        }
        this.sourceFileCharset = value;
    }

    public String getSourceFileCharset() {
        return this.sourceFileCharset;
    }

    public void addUniversalFilter(String value) {
        if (this.universalFilters == null) {
            this.universalFilters = new ArrayList<String>();
        }
        this.universalFilters.add(value);
    }

    public List<String> getUniversalFilters() {
        return this.universalFilters == null ? Collections.emptyList() : this.universalFilters;
    }

    public void addModule(String value) {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
        this.modules.add(value);
    }

    @Nullable
    public List<String> getModules() {
        return this.modules;
    }

    private void addRuntimeDependency(String dependency) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ScopedDependencies();
        }
        if (this.extraDependencies.runtimeOnly == null) {
            this.extraDependencies.runtimeOnly = new ArrayList<String>();
        }
        this.extraDependencies.runtimeOnly.add(dependency);
    }

    private void addCompileDependency(String dependency) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ScopedDependencies();
        }
        if (this.extraDependencies.compileOnly == null) {
            this.extraDependencies.compileOnly = new ArrayList<String>();
        }
        this.extraDependencies.compileOnly.add(dependency);
    }

    private void addAnnotationProcessorDependency(String dependency) {
        if (this.extraDependencies == null) {
            this.extraDependencies = new ScopedDependencies();
        }
        if (this.extraDependencies.annotationProcessor == null) {
            this.extraDependencies.annotationProcessor = new ArrayList<String>();
        }
        this.extraDependencies.annotationProcessor.add(dependency);
    }

    public static class ScopedDependencies {
        @Nullable
        public List<String> runtimeOnly;
        @Nullable
        public List<String> compileOnly;
        @Nullable
        public List<String> annotationProcessor;
    }

    public static class DataFunction
    extends MCPConfigV1.Function {
        protected Map<String, String> data;

        public Map<String, String> getData() {
            return this.data == null ? Collections.emptyMap() : this.data;
        }

        @Nullable
        public String setData(String name, String path) {
            if (this.data == null) {
                this.data = new HashMap<String, String>();
            }
            return this.data.put(name, path);
        }
    }
}

