/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.DiffOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.OutputStream;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class GeneratePatches
extends DefaultTask {
    private int contextLines = -1;
    private boolean autoHeader;
    private boolean verbose;
    private boolean printSummary;

    public GeneratePatches() {
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
        this.getLineEnding().convention((Object)System.lineSeparator());
    }

    @TaskAction
    public void doTask() throws Exception {
        Path base = ((RegularFile)this.getBase().get()).getAsFile().toPath();
        Path modified = ((RegularFile)this.getModified().get()).getAsFile().toPath();
        Path output = ((Directory)this.getOutput().get()).getAsFile().toPath();
        this.getProject().getLogger().info("Base: {}", (Object)base);
        this.getProject().getLogger().info("Modified: {}", (Object)modified);
        ArchiveFormat outputFormat = (ArchiveFormat)this.getOutputFormat().getOrNull();
        if (outputFormat == null) {
            outputFormat = ArchiveFormat.findFormat((Path)output.getFileName());
        }
        DiffOperation.Builder builder = DiffOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.LIFECYCLE)).aPath(base).bPath(modified).outputPath(output, outputFormat).autoHeader(this.autoHeader).verbose(this.verbose).summary(this.printSummary).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).lineEnding((String)this.getLineEnding().get());
        if (this.contextLines != -1) {
            builder.context(this.contextLines);
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
    }

    @InputFile
    public abstract RegularFileProperty getBase();

    @InputFile
    public abstract RegularFileProperty getModified();

    @OutputDirectory
    public abstract DirectoryProperty getOutput();

    @Input
    @Optional
    public abstract Property<ArchiveFormat> getOutputFormat();

    @Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @Input
    public abstract Property<String> getLineEnding();

    @Input
    public boolean isAutoHeader() {
        return this.autoHeader;
    }

    public void setAutoHeader(boolean autoHeader) {
        this.autoHeader = autoHeader;
    }

    @Input
    public int getContextLines() {
        return this.contextLines;
    }

    public void setContextLines(int lines) {
        this.contextLines = lines;
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }
}

