/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.srgutils.IMappingFile;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class RenameJar
extends JarExec {
    private final Provider<RegularFile> tempMappings;
    private boolean useArgsFile;

    public RenameJar() {
        this.tempMappings = this.workDir.map(s -> s.file("mappings.tsrg"));
        this.useArgsFile = false;
        this.getTool().set((Object)Utils.FART);
        this.getArgs().addAll((Object[])new String[]{"--input", "{input}", "--output", "{output}", "--names", "{mappings}", "--lib", "{libraries}"});
        this.getArgsFile().convention(this.workDir.map(d -> d.file("command_line_args.txt")));
    }

    @Override
    protected List<String> filterArgs(List<String> args) throws IOException {
        List<String> ret = this.replaceArgsMulti(args, (Map<String, ?>)ImmutableMap.of((Object)"{input}", (Object)((RegularFile)this.getInput().get()).getAsFile(), (Object)"{output}", (Object)((RegularFile)this.getOutput().get()).getAsFile(), (Object)"{mappings}", (Object)((RegularFile)this.tempMappings.get()).getAsFile()), (Multimap<String, ?>)ImmutableMultimap.builder().putAll((Object)"{libraries}", (Iterable)this.getLibraries().getFiles()).build());
        if (!this.useArgsFile) {
            return ret;
        }
        File argsFile = ((RegularFile)this.getArgsFile().get()).getAsFile();
        Files.write(argsFile.toPath(), ret, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return Arrays.asList("--cfg", argsFile.getAbsolutePath());
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        File tempMappings = ((RegularFile)this.tempMappings.get()).getAsFile();
        if (tempMappings.getParentFile() != null && !tempMappings.getParentFile().exists() && !tempMappings.getParentFile().mkdirs()) {
            this.getProject().getLogger().warn("Could not create parent directories for temp dir '{}'", (Object)tempMappings.getAbsolutePath());
        }
        if (tempMappings.exists() && !tempMappings.delete()) {
            throw new IllegalStateException("Could not delete temp mappings file: " + tempMappings.getAbsolutePath());
        }
        IMappingFile mappings = IMappingFile.load((File)((RegularFile)this.getMappings().get()).getAsFile());
        for (File file : this.getExtraMappings().getFiles()) {
            mappings = mappings.merge(IMappingFile.load((File)file));
        }
        mappings.write(tempMappings.toPath(), IMappingFile.Format.TSRG2, false);
        super.apply();
        tempMappings.delete();
    }

    @InputFile
    public abstract RegularFileProperty getMappings();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getExtraMappings();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getLibraries();

    @InputFile
    public abstract RegularFileProperty getInput();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Internal
    public abstract RegularFileProperty getArgsFile();

    @Internal
    public boolean getUseArgsFile() {
        return this.useArgsFile;
    }

    public void setUseArgsFile(boolean value) {
        this.useArgsFile = value;
    }

    public void useArgsFile() {
        this.useArgsFile = true;
    }
}

