/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

@CacheableTask
public class HackyJavaCompile
extends JavaCompile {
    public void doHackyCompile() {
        this.setCompiler();
        this.getOutputs().setPreviousOutputFiles((FileCollection)this.getProject().files(new Object[0]));
        DefaultJavaCompileSpec spec = this.reflectCreateSpec();
        spec.setSourceFiles((Iterable)this.getSource());
        Compiler<JavaCompileSpec> compiler = this.createCompiler((JavaCompileSpec)spec);
        WorkResult execute = compiler.execute((CompileSpec)spec);
        this.setDidWork(execute.getDidWork());
    }

    private void setCompiler() {
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        Provider compiler = service.compilerFor(s -> s.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)this.getSourceCompatibility())));
        this.getJavaCompiler().set(compiler);
    }

    private DefaultJavaCompileSpec reflectCreateSpec() {
        try {
            Method createSpec = JavaCompile.class.getDeclaredMethod("createSpec", new Class[0]);
            createSpec.setAccessible(true);
            return (DefaultJavaCompileSpec)createSpec.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find JavaCompile#createSpec method; might be on incompatible newer version of Gradle", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Exception while invoking JavaCompile#createSpec", e);
        }
    }

    private Compiler<JavaCompileSpec> createCompiler(JavaCompileSpec spec) {
        try {
            Method createCompiler = JavaCompile.class.getDeclaredMethod("createCompiler", new Class[0]);
            createCompiler.setAccessible(true);
            return (Compiler)createCompiler.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find JavaCompile#createCompiler method; might be on incompatible newer version of Gradle", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Exception while invoking JavaCompile#createCompiler", e);
        }
    }
}

