/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class CreateFakeSASPatches
extends DefaultTask {
    public CreateFakeSASPatches() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(d -> d.dir("patches")));
    }

    @InputFiles
    public abstract ConfigurableFileCollection getFiles();

    @OutputDirectory
    public abstract DirectoryProperty getOutput();

    @TaskAction
    public void apply() throws IOException {
        File output = ((Directory)this.getOutput().get()).getAsFile();
        if (output.exists()) {
            output.mkdirs();
        }
        for (File file : this.getFiles()) {
            for (String line : FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8)) {
                String cls;
                File patch;
                int idx = line.indexOf(35);
                if (idx == 0 || line.isEmpty()) continue;
                if (idx != -1) {
                    line = line.substring(0, idx - 1);
                }
                if (line.charAt(0) == '\t') {
                    line = line.substring(1);
                }
                if (!(patch = new File(output, (cls = (line.trim() + "    ").split(" ", -1)[0]) + ".java.patch")).getParentFile().exists()) {
                    patch.getParentFile().mkdirs();
                }
                patch.createNewFile();
            }
        }
    }
}

