/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class SetupMCP
extends DefaultTask {
    public SetupMCP() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(d -> d.file("output.zip")));
        this.getOutputs().upToDateWhen(task -> {
            HashStore cache = new HashStore(this.getProject());
            try {
                cache.load(this.getProject().file((Object)("build/" + this.getName() + "/inputcache.sha1")));
                cache.add("configFile", ((RegularFile)this.getConfig().get()).getAsFile());
                ((Map)this.getPreDecompile().get()).forEach((key, func) -> func.addInputs(cache, key + "."));
                cache.save();
                return cache.isSame() && ((RegularFile)this.getOutput().get()).getAsFile().exists();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    @InputFile
    public abstract RegularFileProperty getConfig();

    @Input
    public abstract Property<String> getPipeline();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    public abstract MapProperty<String, MCPFunction> getPreDecompile();

    @TaskAction
    public void setupMCP() throws Exception {
        File config = ((RegularFile)this.getConfig().get()).getAsFile();
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        MCPConfigV2 mcpconfig = MCPConfigV2.getFromArchive(config);
        MCPRuntime runtime = new MCPRuntime(this.getProject(), config, mcpconfig, (String)this.getPipeline().get(), this.getProject().file((Object)"build/mcp/"), (Map)this.getPreDecompile().get());
        File out = runtime.execute(this.getLogger());
        if (FileUtils.contentEquals((File)out, (File)output)) {
            return;
        }
        Utils.delete(output);
        FileUtils.copyFile((File)out, (File)output);
    }
}

