/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.tasks;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class DownloadMCPConfig
extends DefaultTask {
    @TaskAction
    public void downloadMCPConfig() throws IOException {
        File file = this.getConfigFile();
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        if (output.exists()) {
            if (FileUtils.contentEquals((File)file, (File)output)) {
                this.setDidWork(false);
                return;
            }
            output.delete();
        }
        FileUtils.copyFile((File)file, (File)output);
        this.setDidWork(true);
    }

    @Input
    public abstract Property<String> getConfig();

    @Internal
    public File getConfigFile() {
        return this.downloadConfigFile((String)this.getConfig().get());
    }

    @OutputFile
    public abstract RegularFileProperty getOutput();

    private File downloadConfigFile(String config) {
        return MavenArtifactDownloader.manual(this.getProject(), config, false);
    }
}

