/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.legacy;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import net.minecraftforge.gradle.common.legacy.FormatSRG;
import net.minecraftforge.gradle.common.tasks.ExtractMCPData;
import net.minecraftforge.gradle.common.tasks.ExtractZip;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public abstract class LegacyExtension
extends GroovyObjectSupport {
    public static final String EXTENSION_NAME = "legacy";
    private static final MinecraftVersion FG3 = MinecraftVersion.from((String)"1.13");

    public static void runRetrogradleFixes(Project project) {
        LegacyExtension config = (LegacyExtension)((Object)project.getExtensions().getByName(EXTENSION_NAME));
        MinecraftExtension minecraft = (MinecraftExtension)((Object)project.getExtensions().getByType(MinecraftExtension.class));
        boolean shouldFixClasspath = (Boolean)config.getFixClasspath().get();
        boolean shouldExtractMappings = (Boolean)config.getExtractMappings().get();
        boolean shouldAttachMappings = (Boolean)config.getAttachMappings().get();
        if (shouldFixClasspath) {
            project.getLogger().info("LegacyExtension: Fixing classpath");
            ConfigurableFileCollection jar = project.files(new Object[]{project.getTasks().named("jar")});
            minecraft.getRuns().stream().flatMap(runConfig -> runConfig.getAllSources().stream()).distinct().forEach(arg_0 -> LegacyExtension.lambda$runRetrogradleFixes$1((FileCollection)jar, arg_0));
        }
        if (shouldExtractMappings) {
            project.getLogger().info("LegacyExtension: Extracting Mappings");
            ExtractZip extractMappingsTask = (ExtractZip)project.getTasks().create("extractMappings", ExtractZip.class, t -> {
                t.getZip().fileProvider(project.provider(() -> {
                    String MAPPING_DEP = "net.minecraft:mappings_{CHANNEL}:{VERSION}@zip";
                    String coordinates = MAPPING_DEP.replace("{CHANNEL}", (CharSequence)minecraft.getMappingChannel().get()).replace("{VERSION}", (CharSequence)minecraft.getMappingVersion().get());
                    Dependency dep = project.getDependencies().create((Object)coordinates);
                    return project.getConfigurations().detachedConfiguration(new Dependency[]{dep}).getSingleFile();
                }));
                t.getOutput().convention(project.getLayout().getBuildDirectory().dir(t.getName()));
            });
            File csvDir = ((Directory)extractMappingsTask.getOutput().get()).getAsFile();
            minecraft.getRuns().configureEach(run -> run.property("net.minecraftforge.gradle.GradleStart.csvDir", csvDir));
            project.getTasks().named("prepareRuns").configure(t -> t.dependsOn(new Object[]{extractMappingsTask}));
        }
        if (shouldAttachMappings) {
            project.getLogger().info("LegacyExtension: Attaching mappings path to runs");
            TaskProvider extractSrg = project.getTasks().named("extractSrg", ExtractMCPData.class);
            TaskProvider createLegacyObf2Srg = project.getTasks().register("createLegacyObf2Srg", FormatSRG.class, t -> {
                t.getSrg().set(extractSrg.flatMap(ExtractMCPData::getOutput));
                t.getFormat().set((Object)IMappingFile.Format.SRG);
            });
            Provider mappingsFile = createLegacyObf2Srg.flatMap(t -> t.getOutput().getAsFile());
            minecraft.getRuns().configureEach(run -> run.property("net.minecraftforge.gradle.GradleStart.srg.notch-srg", (File)mappingsFile.get()));
            project.getTasks().named("prepareRuns").configure(t -> t.dependsOn(new Object[]{createLegacyObf2Srg}));
        }
    }

    public LegacyExtension(Project project) {
        Provider isLegacy = project.provider(() -> {
            String ver = "";
            for (Project proj = project; proj != null; proj = proj.getParent()) {
                if (!proj.getExtensions().getExtraProperties().has("MC_VERSION")) continue;
                ver = (String)proj.getExtensions().getExtraProperties().get("MC_VERSION");
            }
            if (ver == null || ver.isEmpty()) {
                return false;
            }
            MinecraftVersion version = MinecraftVersion.from((String)ver);
            return version.compareTo(FG3) < 0;
        });
        this.getFixClasspath().convention(isLegacy);
        this.getExtractMappings().convention(isLegacy);
        this.getAttachMappings().convention(isLegacy);
    }

    public abstract Property<Boolean> getFixClasspath();

    public abstract Property<Boolean> getExtractMappings();

    public abstract Property<Boolean> getAttachMappings();

    private static /* synthetic */ void lambda$runRetrogradleFixes$1(FileCollection jar, SourceSet sourceSet) {
        sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().minus((FileCollection)sourceSet.getOutput()).plus(jar));
    }
}

