/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.util;

import groovy.namespace.QName;
import groovy.util.Node;
import groovy.util.NodeList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.XmlProvider;

public class MavenPomUtils {
    public static final String MAVEN_POM_NAMESPACE = "{http://maven.apache.org/POM/4.0.0}";

    private MavenPomUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: MavenPomUtils. This is a utility class");
    }

    public static boolean hasChildWithText(Node node, String childKey, String ... candidateValues) {
        NodeList children = node.getAt(QName.valueOf((String)childKey));
        List childList = children.stream().map(Node.class::cast).collect(Collectors.toList());
        return childList.stream().anyMatch(el -> Arrays.stream(candidateValues).anyMatch(value -> value.equals(el.text())));
    }

    public static boolean hasChildWithContainedText(Node node, String childKey, String expectedValue) {
        NodeList children = node.getAt(QName.valueOf((String)childKey));
        List childList = children.stream().map(Node.class::cast).collect(Collectors.toList());
        return childList.stream().anyMatch(el -> el.text().contains(expectedValue));
    }

    public static String getChildText(Node node, String childKey) {
        NodeList children = node.getAt(QName.valueOf((String)childKey));
        List childList = children.stream().map(Node.class::cast).collect(Collectors.toList());
        return childList.stream().map(Node::text).findFirst().orElse("");
    }

    public static void setChildText(Node node, String childKey, String expectedValue) {
        NodeList children = node.getAt(QName.valueOf((String)childKey));
        List<Node> childList = children.stream().map(Node.class::cast).collect(Collectors.toList());
        childList.forEach(el -> el.setValue((Object)expectedValue));
    }

    public static NodeList getDependenciesNodeList(XmlProvider xml) {
        Node dependenciesNode = MavenPomUtils.getDependenciesNode(xml);
        return dependenciesNode.getAt(QName.valueOf((String)"{http://maven.apache.org/POM/4.0.0}*"));
    }

    public static Node getDependenciesNode(XmlProvider xml) {
        NodeList potentialDependenciesList = xml.asNode().getAt(QName.valueOf((String)"{http://maven.apache.org/POM/4.0.0}dependencies"));
        Node dependenciesNode = potentialDependenciesList.isEmpty() ? xml.asNode().appendNode((Object)"dependencies") : (Node)potentialDependenciesList.get(0);
        return dependenciesNode;
    }

    public static List<Node> getDependencyNodes(XmlProvider xml) {
        NodeList existingDependencies = MavenPomUtils.getDependenciesNodeList(xml);
        return existingDependencies.stream().map(Node.class::cast).collect(Collectors.toList());
    }
}

