/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.work.NormalizeLineEndings;

@CacheableTask
public abstract class AccessTransformJar
extends JarExec {
    public AccessTransformJar() {
        this.getTool().set((Object)Utils.ACCESSTRANSFORMER);
        this.getArgs().addAll((Object[])new String[]{"--inJar", "{input}", "--outJar", "{output}", "--logFile", "accesstransform.log"});
    }

    @Override
    protected List<String> filterArgs(List<String> args) {
        List<String> newArgs = this.replaceArgs(args, (Map<String, ?>)ImmutableMap.of((Object)"{input}", (Object)((RegularFile)this.getInput().get()).getAsFile().getAbsolutePath(), (Object)"{output}", (Object)((RegularFile)this.getOutput().get()).getAsFile().getAbsolutePath()), null);
        this.getAccessTransformers().forEach(f -> {
            newArgs.add("--atFile");
            newArgs.add(f.getAbsolutePath());
        });
        return newArgs;
    }

    @InputFiles
    @SkipWhenEmpty
    @NormalizeLineEndings
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getAccessTransformers();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getInput();

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

