/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.srgutils.IMappingFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ReobfuscateJar
extends JarExec {
    private boolean keepPackages = false;
    private boolean keepData = false;
    private boolean useArgsFile = false;
    private final Provider<RegularFile> outputTemp = this.workDir.map(d -> d.file("output_temp.jar"));

    public ReobfuscateJar() {
        this.getTool().set((Object)Utils.FART);
        this.getArgs().addAll((Object[])new String[]{"--input", "{input}", "--output", "{output}", "--names", "{srg}", "--lib", "{libraries}"});
        this.getOutput().convention(this.workDir.map(d -> d.file("output.jar")));
        this.getArgsFile().convention(this.workDir.map(d -> d.file("command_line_args.txt")));
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        super.apply();
        try (BufferedOutputStream log = new BufferedOutputStream(Files.newOutputStream(((RegularFile)this.logFile.get()).getAsFile().toPath(), StandardOpenOption.WRITE, StandardOpenOption.APPEND));){
            HashSet<String> packages = new HashSet<String>();
            IMappingFile srgMappings = IMappingFile.load((File)((RegularFile)this.getSrg().get()).getAsFile());
            for (IMappingFile.IClass srgClass : srgMappings.getClasses()) {
                String named = srgClass.getOriginal();
                int idx = named.lastIndexOf(47);
                if (idx == -1) continue;
                packages.add(named.substring(0, idx + 1) + "package-info.class");
            }
            try (ZipFile zin = new ZipFile(((RegularFile)this.outputTemp.get()).getAsFile());
                 ZipOutputStream out = new ZipOutputStream(new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile()));){
                Enumeration<? extends ZipEntry> enu = zin.entries();
                while (enu.hasMoreElements()) {
                    boolean filter;
                    ZipEntry entry = enu.nextElement();
                    boolean bl = filter = entry.isDirectory() || entry.getName().startsWith("mcp/");
                    if (!this.keepPackages) {
                        filter |= packages.contains(entry.getName());
                    }
                    if (!this.keepData) {
                        filter |= !entry.getName().endsWith(".class");
                    }
                    if (filter) {
                        ((OutputStream)log).write(("Filtered: " + entry.getName() + '\n').getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    out.putNextEntry(entry);
                    IOUtils.copy((InputStream)zin.getInputStream(entry), (OutputStream)out);
                    out.closeEntry();
                }
            }
            ((RegularFile)this.outputTemp.get()).getAsFile().delete();
        }
    }

    @Override
    protected List<String> filterArgs(List<String> args) throws IOException {
        List<String> ret = this.replaceArgsMulti(args, (Map<String, ?>)ImmutableMap.of((Object)"{input}", (Object)((RegularFile)this.getInput().get()).getAsFile(), (Object)"{output}", (Object)((RegularFile)this.outputTemp.get()).getAsFile(), (Object)"{srg}", (Object)((RegularFile)this.getSrg().get()).getAsFile()), (Multimap<String, ?>)ImmutableMultimap.builder().putAll((Object)"{libraries}", (Iterable)this.getLibraries().getFiles()).build());
        if (!this.useArgsFile) {
            return ret;
        }
        File argsFile = ((RegularFile)this.getArgsFile().get()).getAsFile();
        Files.write(argsFile.toPath(), ret, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return Arrays.asList("--cfg", argsFile.getAbsolutePath());
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @InputFile
    public abstract RegularFileProperty getSrg();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Internal
    public abstract RegularFileProperty getArgsFile();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getLibraries();

    @Input
    public boolean getKeepPackages() {
        return this.keepPackages;
    }

    public void keepPackages() {
        this.keepPackages = true;
    }

    public void filterPackages() {
        this.keepPackages = false;
    }

    @Input
    public boolean getKeepData() {
        return this.keepData;
    }

    public void keepData() {
        this.keepData = true;
    }

    public void filterData() {
        this.keepData = false;
    }

    @Internal
    public boolean getUseArgsFile() {
        return this.useArgsFile;
    }

    public void setUseArgsFile(boolean value) {
        this.useArgsFile = value;
    }

    public void useArgsFile() {
        this.useArgsFile = true;
    }
}

