/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.Artifact;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public abstract class MCPExtension {
    public static final String EXTENSION_NAME = "mcp";
    protected final Project project;
    private final Property<Artifact> config;

    @Inject
    public MCPExtension(Project project) {
        this.project = project;
        this.config = project.getObjects().property(Artifact.class);
    }

    public Property<Artifact> getConfig() {
        return this.config;
    }

    public void setConfig(Provider<String> value) {
        this.getConfig().set(value.map(s -> {
            if (s.indexOf(58) != -1) {
                return Artifact.from(s);
            }
            return Artifact.from("de.oceanlabs.mcp:mcp_config:" + s + "@zip");
        }));
    }

    public void setConfig(String value) {
        this.setConfig((Provider<String>)this.project.provider(() -> value));
    }

    public abstract Property<String> getPipeline();
}

