/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.runs.EclipseRunGenerator;
import net.minecraftforge.gradle.common.util.runs.IntellijRunGenerator;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public class VSCodeRunGenerator
extends RunConfigGenerator.JsonConfigurationBuilder {
    @Override
    protected JsonObject createRunConfiguration(Project project, RunConfig runConfig, List<String> additionalClientArgs, FileCollection minecraftArtifacts, FileCollection runtimeClasspathArtifacts) {
        Map<String, Supplier<String>> updatedTokens = VSCodeRunGenerator.configureTokensLazy(project, runConfig, this.mapModClassesToVSCode(project, runConfig), minecraftArtifacts, runtimeClasspathArtifacts);
        JsonObject config = new JsonObject();
        config.addProperty("type", "java");
        config.addProperty("name", runConfig.getTaskName());
        config.addProperty("request", "launch");
        config.addProperty("mainClass", runConfig.getMain());
        config.addProperty("projectName", EclipseRunGenerator.getEclipseProjectName(project));
        config.addProperty("cwd", VSCodeRunGenerator.replaceRootDirBy(project, runConfig.getWorkingDirectory(), "${workspaceFolder}"));
        config.addProperty("vmArgs", VSCodeRunGenerator.getJvmArgs(runConfig, additionalClientArgs, updatedTokens));
        config.addProperty("args", VSCodeRunGenerator.getArgs(runConfig, updatedTokens));
        JsonObject env = new JsonObject();
        runConfig.getEnvironment().forEach((key, value) -> {
            value = runConfig.replace(updatedTokens, (String)value);
            if (key.equals("nativesDirectory")) {
                value = VSCodeRunGenerator.replaceRootDirBy(project, value, "${workspaceFolder}");
            }
            env.addProperty(key, value);
        });
        config.add("env", (JsonElement)env);
        config.addProperty("preLaunchTask", runConfig.getPrepareCompileTaskName());
        return config;
    }

    @Override
    protected JsonObject createPrepareTaskConfiguration(Project project, RunConfig runConfig) {
        JsonObject config = new JsonObject();
        config.addProperty("label", runConfig.getPrepareCompileTaskName());
        config.addProperty("type", "shell");
        config.addProperty("command", "./gradlew " + runConfig.getPrepareCompileTaskName());
        JsonObject options = new JsonObject();
        options.addProperty("cwd", "${workspaceFolder}");
        config.add("options", (JsonElement)options);
        return config;
    }

    private Stream<String> mapModClassesToVSCode(Project project, RunConfig runConfig) {
        return IntellijRunGenerator.mapModClassesToGradle(project, runConfig).map(value -> VSCodeRunGenerator.replaceRootDirBy(project, value, "${workspaceFolder}"));
    }
}

