/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.work.DisableCachingByDefault;

@NonNullApi
@DisableCachingByDefault(because="The output file is often the same as the input file and we have to work around Gradle 8 behavior by not marking the output file as an output")
public abstract class SignJar
extends DefaultTask
implements PatternFilterable {
    private final PatternSet patternSet = new PatternSet();

    @TaskAction
    public void doTask() throws IOException {
        HashMap ignoredStuff = Maps.newHashMap();
        File input = ((RegularFile)this.getInputFile().get()).getAsFile();
        File toSign = new File(this.getTemporaryDir(), input.getName() + ".unsigned.tmp");
        File signed = new File(this.getTemporaryDir(), input.getName() + ".signed.tmp");
        File output = ((RegularFile)this.getOutputFile().get()).getAsFile();
        this.processInputJar(input, toSign, ignoredStuff);
        HashMap map = Maps.newHashMap();
        map.put("alias", this.getAlias().get());
        map.put("storePass", this.getStorePass().get());
        map.put("jar", toSign.getAbsolutePath());
        map.put("signedJar", signed.getAbsolutePath());
        if (this.getKeyPass().isPresent()) {
            map.put("keypass", this.getKeyPass().get());
        }
        if (this.getKeyStore().isPresent()) {
            map.put("keyStore", this.getKeyStore().get());
        }
        this.getProject().getAnt().invokeMethod("signjar", (Object)map);
        this.writeOutputJar(signed, output, ignoredStuff);
    }

    private void processInputJar(File inputJar, File toSign, final Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        final Spec spec = this.patternSet.getAsSpec();
        toSign.getParentFile().mkdirs();
        final JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(toSign)));
        this.getProject().zipTree((Object)inputJar).visit(new FileVisitor(){

            public void visitDir(FileVisitDetails details) {
                try {
                    String path = details.getPath();
                    ZipEntry entry = new ZipEntry(path.endsWith("/") ? path : path + "/");
                    outs.putNextEntry(entry);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void visitFile(FileVisitDetails details) {
                try {
                    if (spec.isSatisfiedBy((Object)details)) {
                        ZipEntry entry = new ZipEntry(details.getPath());
                        entry.setTime(details.getLastModified());
                        outs.putNextEntry(entry);
                        details.copyTo((OutputStream)outs);
                        outs.closeEntry();
                    } else {
                        InputStream stream = details.open();
                        unsigned.put(details.getPath(), new MapEntry((Object)ByteStreams.toByteArray((InputStream)stream), (Object)details.getLastModified()));
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        outs.close();
    }

    private void writeOutputJar(File signedJar, File outputJar, Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        ZipEntry n;
        outputJar.getParentFile().mkdirs();
        JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));
        ZipFile base = new ZipFile(signedJar);
        for (ZipEntry zipEntry : Collections.list(base.entries())) {
            if (zipEntry.isDirectory()) {
                outs.putNextEntry(zipEntry);
                continue;
            }
            n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            outs.putNextEntry(n);
            ByteStreams.copy((InputStream)base.getInputStream(zipEntry), (OutputStream)outs);
            outs.closeEntry();
        }
        base.close();
        for (Map.Entry entry : unsigned.entrySet()) {
            n = new ZipEntry((String)entry.getKey());
            n.setTime((Long)((Map.Entry)entry.getValue()).getValue());
            outs.putNextEntry(n);
            outs.write((byte[])((Map.Entry)entry.getValue()).getKey());
            outs.closeEntry();
        }
        outs.close();
    }

    @InputFile
    public abstract RegularFileProperty getInputFile();

    @Internal
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<String> getAlias();

    @Input
    public abstract Property<String> getStorePass();

    @Input
    @Optional
    public abstract Property<String> getKeyPass();

    @Input
    @Optional
    public abstract Property<String> getKeyStore();

    public PatternFilterable exclude(String ... arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Iterable<String> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Spec<FileTreeElement> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Closure arg0) {
        return this.patternSet.exclude(arg0);
    }

    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public PatternFilterable include(String ... arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Iterable<String> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Spec<FileTreeElement> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Closure arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable setExcludes(Iterable<String> arg0) {
        return this.patternSet.setExcludes(arg0);
    }

    public PatternFilterable setIncludes(Iterable<String> arg0) {
        return this.patternSet.setIncludes(arg0);
    }
}

