/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ExtractMCPData
extends DefaultTask {
    private boolean allowEmpty = false;

    public ExtractMCPData() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(s -> s.file("output.srg")));
        this.getKey().convention((Object)"mappings");
    }

    @TaskAction
    public void run() throws IOException {
        MCPConfigV2 cfg = MCPConfigV2.getFromArchive(((RegularFile)this.getConfig().get()).getAsFile());
        String key = (String)this.getKey().get();
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        try (ZipFile zip = new ZipFile(((RegularFile)this.getConfig().get()).getAsFile());){
            String path = cfg.getData(key.split("/"));
            if (path == null && "statics".equals(key)) {
                path = "config/static_methods.txt";
            }
            if (path == null) {
                this.error("Could not find data entry for '" + key + "'");
                return;
            }
            ZipEntry entry = zip.getEntry(path);
            if (entry == null) {
                this.error("Invalid config zip, Missing path '" + path + "'");
                return;
            }
            try (FileOutputStream out = new FileOutputStream(output);){
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
            }
        }
        if (cfg.isOfficial() && output.exists() && "mappings".equals(key)) {
            IMappingFile obfToSrg = IMappingFile.load((File)output);
            ExtractMCPData.remapSrgClasses(this.getProject(), cfg, obfToSrg).write(output.toPath(), IMappingFile.Format.TSRG2, false);
        }
    }

    public static IMappingFile remapSrgClasses(Project project, MCPConfigV2 config, IMappingFile obfToSrg) throws IOException {
        String minecraftVersion = MinecraftRepo.getMCVersion(config.getVersion());
        File client = MavenArtifactDownloader.generate(project, "net.minecraft:client:" + minecraftVersion + ":mappings@txt", true);
        final IMappingFile obfToOfficial = IMappingFile.load((File)client).reverse();
        return obfToSrg.rename(new IRenamer(){

            public String rename(IMappingFile.IClass value) {
                return obfToOfficial.remapClass(value.getOriginal());
            }
        });
    }

    private void error(String message) throws IOException {
        if (!this.isAllowEmpty()) {
            throw new IllegalStateException(message);
        }
        File outputFile = ((RegularFile)this.getOutput().get()).getAsFile();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
    }

    @Input
    public abstract Property<String> getKey();

    @InputFile
    public abstract RegularFileProperty getConfig();

    @Input
    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

