/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.legacy.LegacyExtension;
import net.minecraftforge.gradle.common.tasks.ApplyMappings;
import net.minecraftforge.gradle.common.tasks.ApplyRangeMap;
import net.minecraftforge.gradle.common.tasks.DownloadAssets;
import net.minecraftforge.gradle.common.tasks.DownloadMCMeta;
import net.minecraftforge.gradle.common.tasks.DownloadMavenArtifact;
import net.minecraftforge.gradle.common.tasks.ExtractExistingFiles;
import net.minecraftforge.gradle.common.tasks.ExtractMCPData;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.tasks.ExtractRangeMap;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.EnvironmentChecks;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.ChannelProvidersExtension;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.tasks.DownloadMCPMappings;
import net.minecraftforge.gradle.mcp.tasks.GenerateSRG;
import net.minecraftforge.gradle.userdev.DependencyManagementExtension;
import net.minecraftforge.gradle.userdev.MinecraftUserRepo;
import net.minecraftforge.gradle.userdev.UserDevExtension;
import net.minecraftforge.gradle.userdev.jarjar.JarJarProjectExtension;
import net.minecraftforge.gradle.userdev.tasks.JarJar;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingRepo;
import net.minecraftforge.gradle.userdev.util.Deobfuscator;
import net.minecraftforge.gradle.userdev.util.DependencyRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class UserDevPlugin
implements Plugin<Project> {
    public static final String JAR_JAR_TASK_NAME = "jarJar";
    public static final String JAR_JAR_GROUP = "jarjar";
    public static final String JAR_JAR_DEFAULT_CONFIGURATION_NAME = "jarJar";
    public static final String MINECRAFT = "minecraft";
    public static final String OBF = "__obfuscated";
    public static final String MINECRAFT_LIBRARY_CONFIGURATION_NAME = "minecraftLibrary";
    public static final String MINECRAFT_EMBED_CONFIGURATION_NAME = "minecraftEmbed";
    private static final String DISABLE_DEFAULT_CONFIGS_PROP = "net.minecraftforge.gradle.disableDefaultMinecraftConfigurations";

    public void apply(@Nonnull Project project) {
        String updateChannel;
        String updateVersion;
        EnvironmentChecks.checkEnvironment(project);
        Utils.addRepoFilters(project);
        Logger logger = project.getLogger();
        UserDevExtension extension = (UserDevExtension)((Object)project.getExtensions().create(MINECRAFT, UserDevExtension.class, new Object[]{project}));
        project.getExtensions().create("channelProviders", ChannelProvidersExtension.class, new Object[0]);
        project.getExtensions().create("legacy", LegacyExtension.class, new Object[0]);
        project.getPluginManager().apply(JavaPlugin.class);
        File nativesFolder = project.file((Object)"build/natives/");
        NamedDomainObjectContainer<RenameJarInPlace> reobfExtension = this.createReobfExtension(project);
        Configuration minecraft = (Configuration)project.getConfigurations().create(MINECRAFT);
        project.getConfigurations().named("implementation").configure(c -> c.extendsFrom(new Configuration[]{minecraft}));
        Configuration internalObfConfiguration = (Configuration)project.getConfigurations().create(OBF);
        internalObfConfiguration.setDescription("Generated scope for obfuscated dependencies");
        Deobfuscator deobfuscator = new Deobfuscator(project, Utils.getCache(project, "deobf_dependencies"));
        DependencyRemapper remapper = new DependencyRemapper(project, deobfuscator);
        DependencyManagementExtension fgExtension = (DependencyManagementExtension)((Object)project.getExtensions().create("fg", DependencyManagementExtension.class, new Object[]{project, remapper, new DeobfuscatingRepo(project, internalObfConfiguration, deobfuscator)}));
        JarJarProjectExtension jarJarExtension = (JarJarProjectExtension)((Object)project.getExtensions().create("jarJar", JarJarProjectExtension.class, new Object[]{project}));
        TaskContainer tasks = project.getTasks();
        TaskProvider downloadMcpConfig = tasks.register("downloadMcpConfig", DownloadMavenArtifact.class);
        TaskProvider extractSrg = tasks.register("extractSrg", ExtractMCPData.class);
        TaskProvider createSrgToMcp = tasks.register("createSrgToMcp", GenerateSRG.class);
        TaskProvider createMcpToSrg = tasks.register("createMcpToSrg", GenerateSRG.class);
        TaskProvider downloadMCMeta = tasks.register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = tasks.register("extractNatives", ExtractNatives.class);
        TaskProvider downloadAssets = tasks.register("downloadAssets", DownloadAssets.class);
        extractSrg.configure(task -> task.getConfig().set(downloadMcpConfig.flatMap(DownloadMavenArtifact::getOutput)));
        createSrgToMcp.configure(task -> {
            task.setReverse(false);
            task.getSrg().set(extractSrg.flatMap(ExtractMCPData::getOutput));
            task.getMappings().set(extension.getMappings());
            task.getFormat().set((Object)IMappingFile.Format.SRG);
            task.getOutput().set(project.getLayout().getBuildDirectory().dir(task.getName()).map(s -> s.file("output.srg")));
        });
        createMcpToSrg.configure(task -> {
            task.setReverse(true);
            task.getSrg().set(extractSrg.flatMap(ExtractMCPData::getOutput));
            task.getMappings().set(extension.getMappings());
        });
        extractNatives.configure(task -> {
            task.getMeta().set(downloadMCMeta.flatMap(DownloadMCMeta::getOutput));
            task.getOutput().set(nativesFolder);
        });
        downloadAssets.configure(task -> task.getMeta().set(downloadMCMeta.flatMap(DownloadMCMeta::getOutput)));
        boolean doingUpdate = project.hasProperty("UPDATE_MAPPINGS");
        String string = updateVersion = doingUpdate ? (String)project.property("UPDATE_MAPPINGS") : null;
        String string2 = doingUpdate ? (project.hasProperty("UPDATE_MAPPINGS_CHANNEL") ? (String)project.property("UPDATE_MAPPINGS_CHANNEL") : "snapshot") : (updateChannel = null);
        if (doingUpdate) {
            logger.lifecycle("This process uses Srg2Source for java source file renaming. Please forward relevant bug reports to https://github.com/MinecraftForge/Srg2Source/issues.");
            TaskProvider javaCompile = tasks.named("compileJava", JavaCompile.class);
            JavaPluginExtension javaConv = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            Property mainJavaSources = project.getObjects().property(FileCollection.class);
            mainJavaSources.finalizeValueOnRead();
            mainJavaSources.set(project.getProviders().gradleProperty("UPDATE_SOURCESETS").orElse((Object)"main").map(s -> s.split(";")).flatMap(sourceSets -> Stream.of(sourceSets).map(sourceSet -> javaConv.getSourceSets().named(sourceSet).map(SourceSet::getJava).map(SourceDirectorySet::getSourceDirectories)).reduce((a, b) -> a.zip(b, FileCollection::plus)).get()));
            TaskProvider dlMappingsNew = tasks.register("downloadMappingsNew", DownloadMCPMappings.class);
            TaskProvider extractRangeConfig = tasks.register("extractRangeMap", ExtractRangeMap.class);
            TaskProvider applyRangeConfig = tasks.register("applyRangeMap", ApplyRangeMap.class);
            TaskProvider toMCPNew = tasks.register("srg2mcpNew", ApplyMappings.class);
            TaskProvider extractMappedNew = tasks.register("extractMappedNew", ExtractExistingFiles.class);
            TaskProvider updateMappings = tasks.register("updateMappings", DefaultTask.class);
            extractRangeConfig.configure(task -> {
                task.getSources().from(new Object[]{mainJavaSources});
                task.getDependencies().from(new Object[]{javaCompile.map(JavaCompile::getClasspath)});
            });
            applyRangeConfig.configure(task -> {
                task.getRangeMap().set(extractRangeConfig.flatMap(ExtractRangeMap::getOutput));
                task.getSrgFiles().from(new Object[]{createMcpToSrg.flatMap(GenerateSRG::getOutput)});
                task.getSources().from(new Object[]{mainJavaSources});
            });
            dlMappingsNew.configure(task -> {
                task.getMappings().set((Object)(updateChannel + "_" + updateVersion));
                task.getOutput().set(project.getLayout().getBuildDirectory().file("mappings_new.zip"));
            });
            toMCPNew.configure(task -> {
                task.getInput().set(applyRangeConfig.flatMap(ApplyRangeMap::getOutput));
                task.getMappings().set(dlMappingsNew.flatMap(DownloadMCPMappings::getOutput));
            });
            extractMappedNew.configure(task -> {
                task.getArchive().set(toMCPNew.flatMap(ApplyMappings::getOutput));
                task.getTargets().from(new Object[]{mainJavaSources});
            });
            updateMappings.configure(task -> task.dependsOn(new Object[]{extractMappedNew}));
        }
        this.configureJarJarTask(project, jarJarExtension);
        if (!project.hasProperty(DISABLE_DEFAULT_CONFIGS_PROP) || !Boolean.parseBoolean((String)project.property(DISABLE_DEFAULT_CONFIGS_PROP))) {
            Configuration minecraftLibrary = (Configuration)project.getConfigurations().create(MINECRAFT_LIBRARY_CONFIGURATION_NAME);
            Configuration minecraftEmbed = (Configuration)project.getConfigurations().create(MINECRAFT_EMBED_CONFIGURATION_NAME);
            project.getConfigurations().named("implementation").configure(c -> c.extendsFrom(new Configuration[]{minecraft, minecraftLibrary, minecraftEmbed}));
            project.getConfigurations().named("jarJar").configure(c -> c.extendsFrom(new Configuration[]{minecraftEmbed}));
            fgExtension.configureMinecraftLibraryConfiguration(minecraftLibrary);
        }
        project.afterEvaluate(p -> {
            MinecraftUserRepo mcrepo = null;
            DependencySet mcDependencies = minecraft.getDependencies();
            for (Dependency dep : new ArrayList(mcDependencies)) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException(minecraft.getName() + " configuration must contain a Maven dependency");
                }
                if (mcrepo != null) {
                    throw new IllegalArgumentException(minecraft.getName() + " configuration must contain exactly one dependency");
                }
                mcDependencies.remove((Object)dep);
                mcrepo = new MinecraftUserRepo((Project)p, dep.getGroup(), dep.getName(), dep.getVersion(), (List<File>)new ArrayList<File>(extension.getAccessTransformers().getFiles()), (String)extension.getMappings().get());
                fgExtension.getRepository().content(content -> content.excludeModule(dep.getGroup(), dep.getName()));
                String newDep = mcrepo.getDependencyString();
                ExternalModuleDependency ext = (ExternalModuleDependency)p.getDependencies().create((Object)newDep);
                minecraft.resolutionStrategy(strat -> strat.cacheChangingModulesFor(10, TimeUnit.SECONDS));
                minecraft.getDependencies().add((Object)ext);
            }
            if (mcrepo == null) {
                if (project.getState().getFailure() != null) {
                    return;
                }
                throw new IllegalStateException("Missing '" + minecraft.getName() + "' dependency.");
            }
            if (EnvironmentChecks.AUTOMATIC_ATTACH_REPOS.isEnabled()) {
                project.getRepositories().maven(Utils.forgeMaven());
            }
            remapper.attachMappings((String)extension.getMappings().get());
            if (fgExtension.getDeobfuscatingRepo().getResolvedOrigin() == null) {
                project.getLogger().error("DeobfRepo attempted to resolve an origin repo early but failed, this may cause issues with some IDEs");
            }
            new BaseRepo.Builder().add(mcrepo).add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
            if (EnvironmentChecks.AUTOMATIC_ATTACH_REPOS.isEnabled()) {
                project.getRepositories().maven(Utils.mojangMaven());
                project.getRepositories().mavenCentral(Utils.filterForge());
            }
            mcrepo.validate(minecraft, extension.getRuns().getAsMap(), (ExtractNatives)((Object)((Object)extractNatives.get())), (DownloadAssets)((Object)((Object)downloadAssets.get())), (GenerateSRG)((Object)((Object)createSrgToMcp.get())));
            String mcVer = (String)project.getExtensions().getExtraProperties().get("MC_VERSION");
            String mcpVer = (String)project.getExtensions().getExtraProperties().get("MCP_VERSION");
            downloadMcpConfig.configure(t -> t.setArtifact("de.oceanlabs.mcp:mcp_config:" + mcpVer + "@zip"));
            downloadMCMeta.configure(t -> t.getMCVersion().convention((Object)mcVer));
            if (extension.getReobf()) {
                reobfExtension.create("jar");
                project.getTasks().withType(JarJar.class).all(jarJar -> {
                    logger.info("Creating reobfuscation task for JarJar task: {}", (Object)jarJar.getName());
                    ((RenameJarInPlace)((Object)((Object)((Object)reobfExtension.create(jarJar.getName()))))).setOnlyIf(task -> jarJar.isEnabled());
                });
            }
            String assetIndex = mcVer;
            try {
                DownloadMCMeta downloadMCMetaTask = (DownloadMCMeta)((Object)((Object)downloadMCMeta.get()));
                File metaOutput = ((RegularFile)downloadMCMetaTask.getOutput().get()).getAsFile();
                if (!metaOutput.exists()) {
                    downloadMCMetaTask.downloadMCMeta();
                }
                VersionJson json = Utils.loadJson(metaOutput, VersionJson.class);
                assetIndex = json.assetIndex.id;
            }
            catch (IOException e) {
                project.getLogger().warn("Failed to retrieve asset index ID", (Throwable)e);
            }
            String finalAssetIndex = assetIndex;
            extension.getRuns().forEach(runConfig -> runConfig.token("asset_index", finalAssetIndex));
            if (extension.getCopyIdeResources().get() == Boolean.TRUE) {
                Utils.setupIDEResourceCopy(project);
            }
            Utils.createRunConfigTasks(extension, (TaskProvider<ExtractNatives>)extractNatives, downloadAssets, createSrgToMcp);
        });
    }

    private NamedDomainObjectContainer<RenameJarInPlace> createReobfExtension(Project project) {
        JavaPluginExtension javaConv = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        NamedDomainObjectContainer reobfExtension = project.container(RenameJarInPlace.class, jarName -> {
            String name = StringUtils.capitalize((String)jarName);
            RenameJarInPlace task = (RenameJarInPlace)((Object)((Object)project.getTasks().maybeCreate("reobf" + name, RenameJarInPlace.class)));
            task.getLibraries().from(new Object[]{javaConv.getSourceSets().named("main").map(SourceSet::getCompileClasspath)});
            task.getMappings().set(project.getTasks().named("createMcpToSrg", GenerateSRG.class).flatMap(GenerateSRG::getOutput));
            project.getTasks().named("assemble").configure(t -> t.dependsOn(new Object[]{task}));
            TaskProvider jarTask = project.getTasks().named(jarName, Jar.class);
            task.getInput().set(jarTask.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getArgs().add((Object)"--disable-abstract-param");
            return task;
        });
        project.getExtensions().add("reobf", (Object)reobfExtension);
        return reobfExtension;
    }

    protected void configureJarJarTask(Project project, JarJarProjectExtension jarJarExtension) {
        Configuration configuration = (Configuration)project.getConfigurations().create("jarJar");
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        project.getTasks().register("jarJar", JarJar.class, jarJar -> {
            jarJar.setGroup(JAR_JAR_GROUP);
            jarJar.setDescription("Create a combined JAR of project and selected dependencies");
            jarJar.getArchiveClassifier().convention((Object)"all");
            if (!jarJarExtension.getDefaultSourcesDisabled()) {
                jarJar.getManifest().inheritFrom(((Jar)project.getTasks().getByName("jar")).getManifest());
                jarJar.from(new Object[]{((SourceSet)javaPluginExtension.getSourceSets().getByName("main")).getOutput()});
            }
            jarJar.configuration(configuration);
            jarJar.setEnabled(false);
        });
        project.getArtifacts().add("jarJar", (Object)project.getTasks().named("jarJar"));
    }
}

